use pbkdf2::pbkdf2;
use sha1::Sha1;
use hmac::Hmac;

pub fn generate_psk_sha1(ssid: &String, passphrase: &String) -> String {
    let mut byte_psk = [0u8; 32];
    pbkdf2::<Hmac<Sha1>>(passphrase.as_bytes(), ssid.as_bytes(), 4096, &mut byte_psk);
    let hex_psk: String = byte_psk.iter().map(|b| format!("{:02x}", b)).collect();
    return hex_psk;
}
