use thiserror::Error;

#[derive(Error, Debug)]
pub enum WorkOSError {
    #[error("resource was not found, id: `{0}`")]
    NotFound(String),
    #[error("the request was not acceptable")]
    NotAcceptable,
    #[error("the api key used was invalid")]
    InvalidApiKey,
    #[error("the api key used did not have the correct permissions")]
    IncorrectPermissions,
    #[error("unknown error")]
    Unknown(#[from] anyhow::Error),
}
