<h1 align="center">workos-rust</h1>
<div align="center">
 <strong>
   unofficial rust sdk for interacting with the workos api
 </strong>
</div>

<br />

<div align="center">
  <!-- Crates version -->
  <a href="https://crates.io/crates/workos-rust">
    <img src="https://img.shields.io/crates/v/workos-rust.svg?style=flat-square"
    alt="Crates.io version" />
  </a>
  <!-- Downloads -->
  <a href="https://crates.io/crates/workos-rust">
    <img src="https://img.shields.io/crates/d/workos-rust?style=flat-square"
      alt="Download" />
  </a>
  <!-- docs.rs docs -->
  <a href="https://docs.rs/workos-rust">
    <img src="https://img.shields.io/badge/docs-latest-blue.svg?style=flat-square"
      alt="docs.rs docs" />
  </a>
</div>

### Example

```rust
use workos_rust::client::Client;

#[async_std::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    let client = Client::new(
        None,
        "WORKOS_API_KEY".to_string(),
    );

    let user = client.get_user("directory_user_01F6HYR5T70NBVQ8E3KDTD2YHC").await?;
    
    println!("{:?}", user);
}
```