use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub static ref SIMP_TO_TRAD: HashMap<char, char> = {
		HashMap::from([
			('内', '內'),
			('丢', '丟'),
			('坂', '阪'),
			('伫', '佇'),
			('吴', '吳'),
			('呐', '吶'),
			('吕', '呂'),
			('壮', '壯'),
			('夹', '夾'),
			('妆', '妝'),
			('决', '決'),
			('灾', '災'),
			('秃', '禿'),
			('见', '見'),
			('贝', '貝'),
			('车', '車'),
			('亚', '亞'),
			('来', '來'),
			('仑', '侖'),
			('儿', '兒'),
			('两', '兩'),
			('协', '協'),
			('届', '屆'),
			('冈', '岡'),
			('东', '東'),
			('殁', '歿'),
			('况', '況'),
			('争', '爭'),
			('状', '狀'),
			('纠', '糾'),
			('苎', '苧'),
			('虬', '虯'),
			('轧', '軋'),
			('长', '長'),
			('门', '門'),
			('侣', '侶'),
			('侠', '俠'),
			('兖', '兗'),
			('则', '則'),
			('刹', '剎'),
			('劲', '勁'),
			('却', '卻'),
			('奂', '奐'),
			('帅', '帥'),
			('彦', '彥'),
			('汹', '洶'),
			('为', '為'),
			('纪', '紀'),
			('纣', '紂'),
			('约', '約'),
			('红', '紅'),
			('纥', '紇'),
			('纫', '紉'),
			('级', '級'),
			('兹', '茲'),
			('荆', '荊'),
			('订', '訂'),
			('讣', '訃'),
			('计', '計'),
			('贞', '貞'),
			('负', '負'),
			('轨', '軌'),
			('军', '軍'),
			('闩', '閂'),
			('陕', '陝'),
			('阵', '陣'),
			('韦', '韋'),
			('页', '頁'),
			('风', '風'),
			('飞', '飛'),
			('伥', '倀'),
			('俩', '倆'),
			('仓', '倉'),
			('个', '個'),
			('们', '們'),
			('伦', '倫'),
			('冻', '凍'),
			('刚', '剛'),
			('剥', '剝'),
			('务', '務'),
			('员', '員'),
			('吣', '唚'),
			('娱', '娛'),
			('孙', '孫'),
			('宫', '宮'),
			('岛', '島'),
			('峡', '峽'),
			('师', '師'),
			('库', '庫'),
			('径', '徑'),
			('耻', '恥'),
			('挟', '挾'),
			('时', '時'),
			('晋', '晉'),
			('书', '書'),
			('条', '條'),
			('杀', '殺'),
			('气', '氣'),
			('泾', '涇'),
			('乌', '烏'),
			('狭', '狹'),
			('狈', '狽'),
			('亩', '畝'),
			('毕', '畢'),
			('疱', '皰'),
			('纹', '紋'),
			('纳', '納'),
			('纽', '紐'),
			('纾', '紓'),
			('纯', '純'),
			('纰', '紕'),
			('纱', '紗'),
			('纸', '紙'),
			('纷', '紛'),
			('纭', '紜'),
			('纺', '紡'),
			('胁', '脅'),
			('脉', '脈'),
			('刍', '芻'),
			('庄', '莊'),
			('茎', '莖'),
			('荚', '莢'),
			('华', '華'),
			('讯', '訊'),
			('讧', '訌'),
			('讨', '討'),
			('讦', '訐'),
			('训', '訓'),
			('讪', '訕'),
			('讫', '訖'),
			('讬', '託'),
			('记', '記'),
			('岂', '豈'),
			('财', '財'),
			('贡', '貢'),
			('轩', '軒'),
			('轫', '軔'),
			('迳', '逕'),
			('这', '這'),
			('连', '連'),
			('邮', '郵'),
			('钊', '釗'),
			('钉', '釘'),
			('针', '針'),
			('闪', '閃'),
			('阴', '陰'),
			('陈', '陳'),
			('陆', '陸'),
			('马', '馬'),
			('伟', '偉'),
			('侧', '側'),
			('侦', '偵'),
			('伪', '偽'),
			('动', '動'),
			('区', '區'),
			('参', '參'),
			('问', '問'),
			('启', '啓'),
			('哑', '啞'),
			('㖞', '喎'),
			('国', '國'),
			('执', '執'),
			('坚', '堅'),
			('够', '夠'),
			('娄', '婁'),
			('妇', '婦'),
			('将', '將'),
			('专', '專'),
			('屉', '屜'),
			('岗', '崗'),
			('峥', '崢'),
			('帐', '帳'),
			('带', '帶'),
			('张', '張'),
			('强', '強'),
			('从', '從'),
			('怅', '悵'),
			('扪', '捫'),
			('扫', '掃'),
			('抡', '掄'),
			('挜', '掗'),
			('挣', '掙'),
			('挂', '掛'),
			('败', '敗'),
			('斩', '斬'),
			('昼', '晝'),
			('枧', '梘'),
			('枭', '梟'),
			('氢', '氫'),
			('凉', '涼'),
			('泪', '淚'),
			('渌', '淥'),
			('沦', '淪'),
			('浅', '淺'),
			('涡', '渦'),
			('牵', '牽'),
			('狰', '猙'),
			('现', '現'),
			('产', '產'),
			('异', '異'),
			('众', '眾'),
			('细', '細'),
			('绅', '紳'),
			('绍', '紹'),
			('绋', '紼'),
			('绌', '絀'),
			('终', '終'),
			('组', '組'),
			('绊', '絆'),
			('钵', '缽'),
			('习', '習'),
			('莱', '萊'),
			('莴', '萵'),
			('处', '處'),
			('术', '術'),
			('衮', '袞'),
			('规', '規'),
			('觅', '覓'),
			('视', '視'),
			('讹', '訛'),
			('讶', '訝'),
			('讼', '訟'),
			('诀', '訣'),
			('讷', '訥'),
			('访', '訪'),
			('设', '設'),
			('许', '許'),
			('贫', '貧'),
			('货', '貨'),
			('贩', '販'),
			('贪', '貪'),
			('贯', '貫'),
			('责', '責'),
			('贬', '貶'),
			('轭', '軛'),
			('软', '軟'),
			('进', '進'),
			('过', '過'),
			('乡', '鄉'),
			('钓', '釣'),
			('钏', '釧'),
			('钗', '釵'),
			('闭', '閉'),
			('阳', '陽'),
			('队', '隊'),
			('阶', '階'),
			('顶', '頂'),
			('顷', '頃'),
			('鱼', '魚'),
			('鸟', '鳥'),
			('卤', '鹵'),
			('麦', '麥'),
			('伧', '傖'),
			('伞', '傘'),
			('备', '備'),
			('凯', '凱'),
			('剀', '剴'),
			('创', '創'),
			('勋', '勛'),
			('胜', '勝'),
			('劳', '勞'),
			('唤', '喚'),
			('丧', '喪'),
			('乔', '喬'),
			('单', '單'),
			('哟', '喲'),
			('围', '圍'),
			('尧', '堯'),
			('报', '報'),
			('场', '場'),
			('块', '塊'),
			('壶', '壺'),
			('寻', '尋'),
			('岚', '嵐'),
			('帧', '幀'),
			('厕', '廁'),
			('厢', '廂'),
			('闷', '悶'),
			('恼', '惱'),
			('恻', '惻'),
			('惬', '愜'),
			('拣', '揀'),
			('扬', '揚'),
			('换', '換'),
			('挥', '揮'),
			('弃', '棄'),
			('枣', '棗'),
			('栋', '棟'),
			('栈', '棧'),
			('栖', '棲'),
			('极', '極'),
			('钦', '欽'),
			('残', '殘'),
			('壳', '殼'),
			('渊', '淵'),
			('涣', '渙'),
			('减', '減'),
			('测', '測'),
			('浑', '渾'),
			('凑', '湊'),
			('汤', '湯'),
			('无', '無'),
			('爷', '爺'),
			('犹', '猶'),
			('珐', '琺'),
			('画', '畫'),
			('痉', '痙'),
			('盗', '盜'),
			('硖', '硤'),
			('砚', '硯'),
			('禄', '祿'),
			('祸', '禍'),
			('秆', '稈'),
			('笔', '筆'),
			('笋', '筍'),
			('结', '結'),
			('绝', '絕'),
			('绞', '絞'),
			('络', '絡'),
			('绚', '絢'),
			('给', '給'),
			('绒', '絨'),
			('统', '統'),
			('丝', '絲'),
			('绑', '綁'),
			('胀', '脹'),
			('肾', '腎'),
			('万', '萬'),
			('叶', '葉'),
			('苇', '葦'),
			('荤', '葷'),
			('虚', '虛'),
			('补', '補'),
			('诉', '訴'),
			('诊', '診'),
			('诂', '詁'),
			('诋', '詆'),
			('诈', '詐'),
			('诏', '詔'),
			('评', '評'),
			('诅', '詛'),
			('词', '詞'),
			('咏', '詠'),
			('贮', '貯'),
			('贰', '貳'),
			('贵', '貴'),
			('买', '買'),
			('贷', '貸'),
			('费', '費'),
			('贴', '貼'),
			('贻', '貽'),
			('贸', '貿'),
			('贺', '賀'),
			('贲', '賁'),
			('轴', '軸'),
			('轲', '軻'),
			('轶', '軼'),
			('运', '運'),
			('达', '達'),
			('违', '違'),
			('邹', '鄒'),
			('钠', '鈉'),
			('钝', '鈍'),
			('钩', '鈎'),
			('钤', '鈐'),
			('钞', '鈔'),
			('钮', '鈕'),
			('钧', '鈞'),
			('钙', '鈣'),
			('钜', '鉅'),
			('开', '開'),
			('闰', '閏'),
			('闲', '閑'),
			('间', '間'),
			('闵', '閔'),
			('陨', '隕'),
			('隽', '雋'),
			('韧', '韌'),
			('项', '項'),
			('顺', '順'),
			('饨', '飩'),
			('饪', '飪'),
			('饬', '飭'),
			('饭', '飯'),
			('饮', '飲'),
			('驭', '馭'),
			('冯', '馮'),
			('黄', '黃'),
			('䢂', '𨋢'),
			('乱', '亂'),
			('传', '傳'),
			('债', '債'),
			('伤', '傷'),
			('倾', '傾'),
			('仅', '僅'),
			('势', '勢'),
			('呛', '嗆'),
			('啬', '嗇'),
			('吗', '嗎'),
			('呜', '嗚'),
			('哔', '嗶'),
			('哗', '嘩'),
			('园', '園'),
			('圆', '圓'),
			('涂', '塗'),
			('坞', '塢'),
			('梦', '夢'),
			('奥', '奧'),
			('妈', '媽'),
			('厦', '廈'),
			('弑', '弒'),
			('爱', '愛'),
			('怆', '愴'),
			('忾', '愾'),
			('损', '損'),
			('摇', '搖'),
			('捣', '搗'),
			('抢', '搶'),
			('晕', '暈'),
			('晖', '暉'),
			('会', '會'),
			('杨', '楊'),
			('枫', '楓'),
			('桢', '楨'),
			('业', '業'),
			('岁', '歲'),
			('毁', '毀'),
			('沟', '溝'),
			('沧', '滄'),
			('灭', '滅'),
			('涤', '滌'),
			('涟', '漣'),
			('炼', '煉'),
			('烟', '煙'),
			('焕', '煥'),
			('烦', '煩'),
			('炀', '煬'),
			('狲', '猻'),
			('狮', '獅'),
			('珲', '琿'),
			('盏', '盞'),
			('睁', '睜'),
			('睐', '睞'),
			('祯', '禎'),
			('禀', '稟'),
			('窝', '窩'),
			('节', '節'),
			('绢', '絹'),
			('绥', '綏'),
			('经', '經'),
			('义', '義'),
			('圣', '聖'),
			('肃', '肅'),
			('脑', '腦'),
			('肿', '腫'),
			('脚', '腳'),
			('肠', '腸'),
			('与', '與'),
			('莅', '蒞'),
			('苍', '蒼'),
			('荪', '蓀'),
			('盖', '蓋'),
			('莲', '蓮'),
			('荫', '蔭'),
			('虏', '虜'),
			('号', '號'),
			('蚬', '蜆'),
			('袅', '裊'),
			('装', '裝'),
			('诩', '詡'),
			('询', '詢'),
			('诣', '詣'),
			('试', '試'),
			('诗', '詩'),
			('诧', '詫'),
			('诟', '詬'),
			('诡', '詭'),
			('诠', '詮'),
			('诘', '詰'),
			('话', '話'),
			('该', '該'),
			('详', '詳'),
			('诙', '詼'),
			('诛', '誅'),
			('诞', '誕'),
			('诚', '誠'),
			('诤', '諍'),
			('赀', '貲'),
			('赂', '賂'),
			('赁', '賃'),
			('贿', '賄'),
			('赅', '賅'),
			('资', '資'),
			('贾', '賈'),
			('贼', '賊'),
			('轼', '軾'),
			('较', '較'),
			('载', '載'),
			('轾', '輊'),
			('农', '農'),
			('遥', '遙'),
			('逊', '遜'),
			('递', '遞'),
			('远', '遠'),
			('铃', '鈴'),
			('钴', '鈷'),
			('钹', '鈸'),
			('铀', '鈾'),
			('钾', '鉀'),
			('铇', '鉋'),
			('铂', '鉑'),
			('钳', '鉗'),
			('铅', '鉛'),
			('闸', '閘'),
			('际', '際'),
			('电', '電'),
			('颂', '頌'),
			('预', '預'),
			('顽', '頑'),
			('颁', '頒'),
			('顿', '頓'),
			('饴', '飴'),
			('饲', '飼'),
			('饱', '飽'),
			('饰', '飾'),
			('驮', '馱'),
			('驰', '馳'),
			('驯', '馴'),
			('肮', '骯'),
			('鸠', '鳩'),
			('侨', '僑'),
			('侥', '僥'),
			('匮', '匱'),
			('厌', '厭'),
			('厉', '厲'),
			('叹', '嘆'),
			('喽', '嘍'),
			('呕', '嘔'),
			('啧', '嘖'),
			('尝', '嘗'),
			('唛', '嘜'),
			('图', '圖'),
			('尘', '塵'),
			('堑', '塹'),
			('垫', '墊'),
			('坠', '墜'),
			('堕', '墮'),
			('寿', '壽'),
			('奁', '奩'),
			('夺', '奪'),
			('妪', '嫗'),
			('寝', '寢'),
			('实', '實'),
			('宁', '寧'),
			('宽', '寬'),
			('对', '對'),
			('屡', '屢'),
			('崭', '嶄'),
			('岖', '嶇'),
			('帼', '幗'),
			('币', '幣'),
			('广', '廣'),
			('态', '態'),
			('惨', '慘'),
			('惭', '慚'),
			('恸', '慟'),
			('惯', '慣'),
			('悭', '慳'),
			('掴', '摑'),
			('搂', '摟'),
			('掺', '摻'),
			('畅', '暢'),
			('荣', '榮'),
			('构', '構'),
			('枪', '槍'),
			('梿', '槤'),
			('椁', '槨'),
			('桦', '樺'),
			('殒', '殞'),
			('沪', '滬'),
			('滞', '滯'),
			('渗', '滲'),
			('滚', '滾'),
			('满', '滿'),
			('渔', '漁'),
			('汉', '漢'),
			('渍', '漬'),
			('涨', '漲'),
			('渐', '漸'),
			('荧', '熒'),
			('尔', '爾'),
			('荦', '犖'),
			('狱', '獄'),
			('琐', '瑣'),
			('瑶', '瑤'),
			('玛', '瑪'),
			('疯', '瘋'),
			('疡', '瘍'),
			('痪', '瘓'),
			('疟', '瘧'),
			('监', '監'),
			('硕', '碩'),
			('种', '種'),
			('称', '稱'),
			('洼', '窪'),
			('笺', '箋'),
			('筝', '箏'),
			('综', '綜'),
			('缍', '綞'),
			('绿', '綠'),
			('绸', '綢'),
			('维', '維'),
			('绾', '綰'),
			('纲', '綱'),
			('网', '網'),
			('缀', '綴'),
			('䌽', '綵'),
			('纶', '綸'),
			('绮', '綺'),
			('绽', '綻'),
			('绰', '綽'),
			('绫', '綾'),
			('绵', '綿'),
			('缁', '緇'),
			('紧', '緊'),
			('绯', '緋'),
			('绪', '緒'),
			('罚', '罰'),
			('闻', '聞'),
			('蒋', '蔣'),
			('蚀', '蝕'),
			('蜗', '蝸'),
			('认', '認'),
			('诳', '誑'),
			('诶', '誒'),
			('诱', '誘'),
			('语', '語'),
			('诫', '誡'),
			('诬', '誣'),
			('误', '誤'),
			('诰', '誥'),
			('诵', '誦'),
			('诲', '誨'),
			('说', '説'),
			('赈', '賑'),
			('赊', '賒'),
			('宾', '賓'),
			('赶', '趕'),
			('赵', '趙'),
			('辄', '輒'),
			('辅', '輔'),
			('轻', '輕'),
			('适', '適'),
			('邓', '鄧'),
			('郑', '鄭'),
			('邻', '鄰'),
			('铰', '鉸'),
			('银', '銀'),
			('铜', '銅'),
			('铨', '銓'),
			('铢', '銖'),
			('铭', '銘'),
			('衔', '銜'),
			('铐', '銬'),
			('铝', '鋁'),
			('铮', '錚'),
			('阂', '閡'),
			('阁', '閣'),
			('阀', '閥'),
			('闺', '閨'),
			('闽', '閩'),
			('闾', '閭'),
			('随', '隨'),
			('颇', '頗'),
			('领', '領'),
			('飒', '颯'),
			('饺', '餃'),
			('饼', '餅'),
			('饷', '餉'),
			('养', '養'),
			('饵', '餌'),
			('驳', '駁'),
			('凤', '鳳'),
			('鸣', '鳴'),
			('鸢', '鳶'),
			('齐', '齊'),
			('价', '價'),
			('仪', '儀'),
			('侬', '儂'),
			('亿', '億'),
			('侩', '儈'),
			('俭', '儉'),
			('凛', '凜'),
			('剧', '劇'),
			('刘', '劉'),
			('刽', '劊'),
			('剑', '劍'),
			('㓥', '劏'),
			('唠', '嘮'),
			('叽', '嘰'),
			('嘘', '噓'),
			('㖊', '噚'),
			('喷', '噴'),
			('坟', '墳'),
			('妩', '嫵'),
			('娴', '嫻'),
			('婵', '嬋'),
			('娇', '嬌'),
			('审', '審'),
			('写', '寫'),
			('导', '導'),
			('层', '層'),
			('帜', '幟'),
			('厨', '廚'),
			('厮', '廝'),
			('庙', '廟'),
			('厂', '廠'),
			('废', '廢'),
			('弹', '彈'),
			('彻', '徹'),
			('怂', '慫'),
			('虑', '慮'),
			('庆', '慶'),
			('忧', '憂'),
			('怜', '憐'),
			('惮', '憚'),
			('愤', '憤'),
			('悯', '憫'),
			('挚', '摯'),
			('捞', '撈'),
			('撑', '撐'),
			('挠', '撓'),
			('拨', '撥'),
			('抚', '撫'),
			('揿', '撳'),
			('挞', '撻'),
			('敌', '敵'),
			('数', '數'),
			('暂', '暫'),
			('桨', '槳'),
			('桩', '樁'),
			('乐', '樂'),
			('楼', '樓'),
			('标', '標'),
			('枢', '樞'),
			('样', '樣'),
			('椭', '橢'),
			('欧', '歐'),
			('殇', '殤'),
			('殴', '毆'),
			('浆', '漿'),
			('泼', '潑'),
			('洁', '潔'),
			('潜', '潛'),
			('润', '潤'),
			('溃', '潰'),
			('浇', '澆'),
			('涧', '澗'),
			('热', '熱'),
			('奖', '獎'),
			('莹', '瑩'),
			('瓯', '甌'),
			('疮', '瘡'),
			('皑', '皚'),
			('皱', '皺'),
			('盘', '盤'),
			('确', '確'),
			('码', '碼'),
			('穷', '窮'),
			('窑', '窯'),
			('箧', '篋'),
			('缄', '緘'),
			('缉', '緝'),
			('缎', '緞'),
			('缔', '締'),
			('缘', '緣'),
			('编', '編'),
			('缓', '緩'),
			('缅', '緬'),
			('纬', '緯'),
			('缈', '緲'),
			('练', '練'),
			('骂', '罵'),
			('罢', '罷'),
			('肤', '膚'),
			('胶', '膠'),
			('芜', '蕪'),
			('猬', '蝟'),
			('虾', '蝦'),
			('裤', '褲'),
			('谁', '誰'),
			('课', '課'),
			('诽', '誹'),
			('谊', '誼'),
			('调', '調'),
			('谄', '諂'),
			('谆', '諄'),
			('谈', '談'),
			('诿', '諉'),
			('请', '請'),
			('谅', '諒'),
			('论', '論'),
			('谂', '諗'),
			('谀', '諛'),
			('诸', '諸'),
			('诺', '諾'),
			('竖', '豎'),
			('猪', '豬'),
			('猫', '貓'),
			('赐', '賜'),
			('赏', '賞'),
			('赔', '賠'),
			('贤', '賢'),
			('卖', '賣'),
			('贱', '賤'),
			('赋', '賦'),
			('质', '質'),
			('账', '賬'),
			('赌', '賭'),
			('践', '踐'),
			('辆', '輛'),
			('辎', '輜'),
			('辉', '輝'),
			('辍', '輟'),
			('辇', '輦'),
			('辈', '輩'),
			('轮', '輪'),
			('迟', '遲'),
			('迁', '遷'),
			('选', '選'),
			('遗', '遺'),
			('辽', '遼'),
			('迈', '邁'),
			('销', '銷'),
			('锑', '銻'),
			('锉', '銼'),
			('锌', '鋅'),
			('锋', '鋒'),
			('锄', '鋤'),
			('铺', '鋪'),
			('锐', '鋭'),
			('阅', '閲'),
			('险', '險'),
			('靓', '靚'),
			('巩', '鞏'),
			('颉', '頡'),
			('馁', '餒'),
			('饿', '餓'),
			('驻', '駐'),
			('驽', '駑'),
			('驹', '駒'),
			('驾', '駕'),
			('驸', '駙'),
			('驶', '駛'),
			('驼', '駝'),
			('驷', '駟'),
			('闹', '鬧'),
			('鲁', '魯'),
			('鱿', '魷'),
			('鸩', '鴆'),
			('鸦', '鴉'),
			('麸', '麩'),
			('齿', '齒'),
			('傧', '儐'),
			('俦', '儔'),
			('侪', '儕'),
			('剂', '劑'),
			('励', '勵'),
			('啸', '嘯'),
			('哝', '噥'),
			('嗳', '噯'),
			('吨', '噸'),
			('垦', '墾'),
			('奋', '奮'),
			('学', '學'),
			('屿', '嶼'),
			('惫', '憊'),
			('凭', '憑'),
			('宪', '憲'),
			('忆', '憶'),
			('懔', '懍'),
			('战', '戰'),
			('捡', '撿'),
			('拥', '擁'),
			('掳', '擄'),
			('择', '擇'),
			('挡', '擋'),
			('担', '擔'),
			('据', '據'),
			('昙', '曇'),
			('晓', '曉'),
			('树', '樹'),
			('桥', '橋'),
			('机', '機'),
			('横', '橫'),
			('泽', '澤'),
			('淀', '澱'),
			('浊', '濁'),
			('浓', '濃'),
			('炽', '熾'),
			('灯', '燈'),
			('烧', '燒'),
			('烫', '燙'),
			('焖', '燜'),
			('营', '營'),
			('独', '獨'),
			('玑', '璣'),
			('卢', '盧'),
			('瞒', '瞞'),
			('砖', '磚'),
			('禅', '禪'),
			('稣', '穌'),
			('积', '積'),
			('颖', '穎'),
			('窥', '窺'),
			('筑', '築'),
			('笃', '篤'),
			('筛', '篩'),
			('萦', '縈'),
			('缢', '縊'),
			('缣', '縑'),
			('缚', '縛'),
			('缜', '縝'),
			('县', '縣'),
			('缝', '縫'),
			('腻', '膩'),
			('兴', '興'),
			('举', '舉'),
			('舱', '艙'),
			('萧', '蕭'),
			('荟', '薈'),
			('蔷', '薔'),
			('荐', '薦'),
			('萨', '薩'),
			('蚂', '螞'),
			('萤', '螢'),
			('卫', '衞'),
			('褛', '褸'),
			('觎', '覦'),
			('亲', '親'),
			('谍', '諜'),
			('谛', '諦'),
			('谐', '諧'),
			('谏', '諫'),
			('谕', '諭'),
			('谘', '諮'),
			('讳', '諱'),
			('谙', '諳'),
			('讽', '諷'),
			('谚', '諺'),
			('谋', '謀'),
			('谒', '謁'),
			('谓', '謂'),
			('谎', '謊'),
			('谜', '謎'),
			('谑', '謔'),
			('赖', '賴'),
			('踊', '踴'),
			('辑', '輯'),
			('输', '輸'),
			('辐', '輻'),
			('办', '辦'),
			('还', '還'),
			('邝', '鄺'),
			('酝', '醖'),
			('锯', '鋸'),
			('钢', '鋼'),
			('录', '錄'),
			('锥', '錐'),
			('锤', '錘'),
			('锱', '錙'),
			('锭', '錠'),
			('钱', '錢'),
			('锦', '錦'),
			('锚', '錨'),
			('锡', '錫'),
			('锢', '錮'),
			('错', '錯'),
			('锰', '錳'),
			('锅', '鍋'),
			('键', '鍵'),
			('阉', '閹'),
			('阎', '閻'),
			('隐', '隱'),
			('静', '靜'),
			('腼', '靦'),
			('颐', '頤'),
			('头', '頭'),
			('颊', '頰'),
			('颔', '頷'),
			('颈', '頸'),
			('颓', '頹'),
			('频', '頻'),
			('馄', '餛'),
			('饯', '餞'),
			('馅', '餡'),
			('馆', '館'),
			('骈', '駢'),
			('骇', '駭'),
			('骆', '駱'),
			('鲍', '鮑'),
			('鲊', '鮓'),
			('鸵', '鴕'),
			('鸳', '鴛'),
			('鸪', '鴣'),
			('鸯', '鴦'),
			('鸭', '鴨'),
			('龙', '龍'),
			('偿', '償'),
			('优', '優'),
			('储', '儲'),
			('咛', '嚀'),
			('压', '壓'),
			('圹', '壙'),
			('嬷', '嬤'),
			('嫔', '嬪'),
			('婴', '嬰'),
			('尴', '尷'),
			('岭', '嶺'),
			('帮', '幫'),
			('恳', '懇'),
			('应', '應'),
			('戏', '戲'),
			('击', '擊'),
			('挤', '擠'),
			('拟', '擬'),
			('拧', '擰'),
			('搁', '擱'),
			('掷', '擲'),
			('扩', '擴'),
			('敛', '斂'),
			('毙', '斃'),
			('暧', '曖'),
			('档', '檔'),
			('桧', '檜'),
			('检', '檢'),
			('栉', '櫛'),
			('欤', '歟'),
			('殓', '殮'),
			('毡', '氈'),
			('涩', '澀'),
			('湿', '濕'),
			('泞', '濘'),
			('济', '濟'),
			('涛', '濤'),
			('滥', '濫'),
			('滨', '濱'),
			('灿', '燦'),
			('烛', '燭'),
			('烩', '燴'),
			('㶶', '燶'),
			('墙', '牆'),
			('狞', '獰'),
			('犷', '獷'),
			('瑷', '璦'),
			('环', '環'),
			('疗', '療'),
			('痨', '癆'),
			('痫', '癇'),
			('疠', '癘'),
			('矫', '矯'),
			('矶', '磯'),
			('礼', '禮'),
			('篓', '簍'),
			('粪', '糞'),
			('缩', '縮'),
			('纵', '縱'),
			('缧', '縲'),
			('缕', '縷'),
			('总', '總'),
			('绩', '績'),
			('绷', '繃'),
			('缫', '繅'),
			('缪', '繆'),
			('联', '聯'),
			('聪', '聰'),
			('声', '聲'),
			('耸', '聳'),
			('胆', '膽'),
			('脍', '膾'),
			('脓', '膿'),
			('脸', '臉'),
			('临', '臨'),
			('旧', '舊'),
			('艰', '艱'),
			('蓝', '藍'),
			('亏', '虧'),
			('蝼', '螻'),
			('蛰', '蟄'),
			('蝈', '蟈'),
			('亵', '褻'),
			('袄', '襖'),
			('觊', '覬'),
			('誊', '謄'),
			('谤', '謗'),
			('谦', '謙'),
			('讲', '講'),
			('谢', '謝'),
			('谣', '謠'),
			('谟', '謨'),
			('赚', '賺'),
			('购', '購'),
			('赛', '賽'),
			('赘', '贅'),
			('趋', '趨'),
			('跄', '蹌'),
			('辗', '輾'),
			('舆', '輿'),
			('毂', '轂'),
			('辖', '轄'),
			('辕', '轅'),
			('迩', '邇'),
			('镀', '鍍'),
			('锻', '鍛'),
			('锲', '鍥'),
			('锹', '鍬'),
			('镁', '鎂'),
			('闱', '闈'),
			('阔', '闊'),
			('阕', '闋'),
			('阑', '闌'),
			('隶', '隸'),
			('虽', '雖'),
			('韩', '韓'),
			('颗', '顆'),
			('飓', '颶'),
			('𩠌', '餸'),
			('馊', '餿'),
			('骏', '駿'),
			('骋', '騁'),
			('鲛', '鮫'),
			('鲜', '鮮'),
			('鸿', '鴻'),
			('鸽', '鴿'),
			('点', '點'),
			('斋', '齋'),
			('龟', '龜'),
			('丛', '叢'),
			('噜', '嚕'),
			('垒', '壘'),
			('婶', '嬸'),
			('懑', '懣'),
			('摆', '擺'),
			('擞', '擻'),
			('扰', '擾'),
			('撵', '攆'),
			('断', '斷'),
			('旷', '曠'),
			('槟', '檳'),
			('柠', '檸'),
			('槛', '檻'),
			('柜', '櫃'),
			('榈', '櫚'),
			('归', '歸'),
			('殡', '殯'),
			('溅', '濺'),
			('滤', '濾'),
			('渎', '瀆'),
			('泻', '瀉'),
			('浏', '瀏'),
			('烬', '燼'),
			('猎', '獵'),
			('琼', '瓊'),
			('础', '礎'),
			('祷', '禱'),
			('穑', '穡'),
			('秽', '穢'),
			('窜', '竄'),
			('窍', '竅'),
			('箪', '簞'),
			('简', '簡'),
			('篑', '簣'),
			('粮', '糧'),
			('织', '織'),
			('缮', '繕'),
			('缭', '繚'),
			('绕', '繞'),
			('茧', '繭'),
			('翘', '翹'),
			('聂', '聶'),
			('职', '職'),
			('脐', '臍'),
			('膑', '臏'),
			('艺', '藝'),
			('药', '藥'),
			('薮', '藪'),
			('蕴', '藴'),
			('蝉', '蟬'),
			('蛲', '蟯'),
			('裆', '襠'),
			('觐', '覲'),
			('觑', '覷'),
			('觞', '觴'),
			('谬', '謬'),
			('讴', '謳'),
			('谨', '謹'),
			('丰', '豐'),
			('蹒', '蹣'),
			('踪', '蹤'),
			('躯', '軀'),
			('辘', '轆'),
			('转', '轉'),
			('边', '邊'),
			('医', '醫'),
			('酱', '醬'),
			('镑', '鎊'),
			('镕', '鎔'),
			('锁', '鎖'),
			('钨', '鎢'),
			('铠', '鎧'),
			('镇', '鎮'),
			('镍', '鎳'),
			('链', '鏈'),
			('阗', '闐'),
			('阖', '闔'),
			('阙', '闕'),
			('闯', '闖'),
			('陇', '隴'),
			('双', '雙'),
			('雏', '雛'),
			('杂', '雜'),
			('鸡', '雞'),
			('离', '離'),
			('雾', '霧'),
			('题', '題'),
			('额', '額'),
			('颚', '顎'),
			('颜', '顏'),
			('飏', '颺'),
			('飕', '颼'),
			('馏', '餾'),
			('馐', '饈'),
			('骑', '騎'),
			('鲩', '鯇'),
			('鲤', '鯉'),
			('鲨', '鯊'),
			('鲫', '鯽'),
			('鹃', '鵑'),
			('鹅', '鵝'),
			('鹄', '鵠'),
			('劝', '勸'),
			('咙', '嚨'),
			('严', '嚴'),
			('垄', '壟'),
			('宠', '寵'),
			('庐', '廬'),
			('惩', '懲'),
			('懒', '懶'),
			('怀', '懷'),
			('拢', '攏'),
			('橹', '櫓'),
			('椟', '櫝'),
			('橱', '櫥'),
			('濒', '瀕'),
			('沥', '瀝'),
			('潇', '瀟'),
			('濑', '瀨'),
			('烁', '爍'),
			('牍', '牘'),
			('犊', '犢'),
			('兽', '獸'),
			('獭', '獺'),
			('玺', '璽'),
			('畴', '疇'),
			('痒', '癢'),
			('碍', '礙'),
			('矿', '礦'),
			('砺', '礪'),
			('稳', '穩'),
			('箫', '簫'),
			('绣', '繡'),
			('绳', '繩'),
			('绘', '繪'),
			('缴', '繳'),
			('绎', '繹'),
			('罗', '羅'),
			('腊', '臘'),
			('蔼', '藹'),
			('蔺', '藺'),
			('芦', '蘆'),
			('苹', '蘋'),
			('蚁', '蟻'),
			('蝇', '蠅'),
			('褴', '襤'),
			('袜', '襪'),
			('证', '證'),
			('谲', '譎'),
			('讥', '譏'),
			('谮', '譖'),
			('识', '識'),
			('谭', '譚'),
			('谱', '譜'),
			('赠', '贈'),
			('赞', '贊'),
			('赝', '贋'),
			('跷', '蹺'),
			('跶', '躂'),
			('趸', '躉'),
			('辙', '轍'),
			('轿', '轎'),
			('辚', '轔'),
			('辞', '辭'),
			('镞', '鏃'),
			('镝', '鏑'),
			('铿', '鏗'),
			('锵', '鏘'),
			('镗', '鏜'),
			('铲', '鏟'),
			('镜', '鏡'),
			('镖', '鏢'),
			('关', '關'),
			('难', '難'),
			('韬', '韜'),
			('韵', '韻'),
			('颠', '顛'),
			('类', '類'),
			('馒', '饅'),
			('馑', '饉'),
			('骛', '騖'),
			('骗', '騙'),
			('骚', '騷'),
			('鲸', '鯨'),
			('鹉', '鵡'),
			('鹌', '鵪'),
			('鹏', '鵬'),
			('鹊', '鵲'),
			('鹑', '鶉'),
			('丽', '麗'),
			('庞', '龐'),
			('嘤', '嚶'),
			('宝', '寶'),
			('悬', '懸'),
			('忏', '懺'),
			('拦', '攔'),
			('搀', '攙'),
			('胧', '朧'),
			('澜', '瀾'),
			('炉', '爐'),
			('牺', '犧'),
			('献', '獻'),
			('珑', '瓏'),
			('砾', '礫'),
			('矾', '礬'),
			('窦', '竇'),
			('竞', '競'),
			('篮', '籃'),
			('筹', '籌'),
			('继', '繼'),
			('缤', '繽'),
			('罂', '罌'),
			('胪', '臚'),
			('舰', '艦'),
			('藓', '蘚'),
			('兰', '蘭'),
			('蛎', '蠣'),
			('觉', '覺'),
			('触', '觸'),
			('译', '譯'),
			('议', '議'),
			('谴', '譴'),
			('护', '護'),
			('誉', '譽'),
			('赡', '贍'),
			('赢', '贏'),
			('辫', '辮'),
			('释', '釋'),
			('镪', '鏹'),
			('铙', '鐃'),
			('锏', '鐧'),
			('阐', '闡'),
			('飘', '飄'),
			('馈', '饋'),
			('饶', '饒'),
			('骞', '騫'),
			('骝', '騮'),
			('腾', '騰'),
			('蓦', '驀'),
			('髅', '髏'),
			('鲗', '鰂'),
			('鳅', '鰍'),
			('鳃', '鰓'),
			('鹜', '鶩'),
			('党', '黨'),
			('龅', '齙'),
			('龃', '齟'),
			('龄', '齡'),
			('俪', '儷'),
			('俨', '儼'),
			('啭', '囀'),
			('嗫', '囁'),
			('嚣', '囂'),
			('呓', '囈'),
			('属', '屬'),
			('惧', '懼'),
			('慑', '懾'),
			('携', '攜'),
			('摄', '攝'),
			('斓', '斕'),
			('樱', '櫻'),
			('栏', '欄'),
			('权', '權'),
			('欢', '歡'),
			('歼', '殲'),
			('烂', '爛'),
			('癞', '癩'),
			('瘾', '癮'),
			('眬', '矓'),
			('缬', '纈'),
			('续', '續'),
			('缠', '纏'),
			('蜡', '蠟'),
			('衬', '襯'),
			('览', '覽'),
			('赃', '贓'),
			('踌', '躊'),
			('跃', '躍'),
			('踯', '躑'),
			('轰', '轟'),
			('辩', '辯'),
			('锈', '鏽'),
			('镰', '鐮'),
			('镯', '鐲'),
			('镭', '鐳'),
			('铁', '鐵'),
			('铎', '鐸'),
			('铛', '鐺'),
			('镬', '鑊'),
			('鞑', '韃'),
			('顾', '顧'),
			('飙', '飆'),
			('骡', '騾'),
			('骠', '驃'),
			('驱', '驅'),
			('鳏', '鰥'),
			('鳍', '鰭'),
			('鲢', '鰱'),
			('莺', '鶯'),
			('鹤', '鶴'),
			('鹞', '鷂'),
			('龈', '齦'),
			('傥', '儻'),
			('啰', '囉'),
			('娈', '孌'),
			('孪', '孿'),
			('峦', '巒'),
			('巅', '巔'),
			('弯', '彎'),
			('摊', '攤'),
			('滩', '灘'),
			('猡', '玀'),
			('叠', '疊'),
			('癣', '癬'),
			('窃', '竊'),
			('籁', '籟'),
			('笼', '籠'),
			('听', '聽'),
			('聋', '聾'),
			('萝', '蘿'),
			('袭', '襲'),
			('读', '讀'),
			('赎', '贖'),
			('辔', '轡'),
			('逻', '邏'),
			('逦', '邐'),
			('铸', '鑄'),
			('鉴', '鑒'),
			('霁', '霽'),
			('缰', '韁'),
			('颤', '顫'),
			('骁', '驍'),
			('骄', '驕'),
			('惊', '驚'),
			('体', '體'),
			('鳗', '鰻'),
			('鳔', '鰾'),
			('鹧', '鷓'),
			('鸥', '鷗'),
			('鼹', '鼴'),
			('龊', '齪'),
			('龉', '齬'),
			('龚', '龔'),
			('龛', '龕'),
			('恋', '戀'),
			('挛', '攣'),
			('搅', '攪'),
			('缨', '纓'),
			('纤', '纖'),
			('蛊', '蠱'),
			('变', '變'),
			('铄', '鑠'),
			('镳', '鑣'),
			('靥', '靨'),
			('显', '顯'),
			('餍', '饜'),
			('验', '驗'),
			('驿', '驛'),
			('魇', '魘'),
			('鳝', '鱔'),
			('鳜', '鱖'),
			('鳞', '鱗'),
			('鸶', '鷥'),
			('嘱', '囑'),
			('坝', '壩'),
			('揽', '攬'),
			('瘫', '癱'),
			('癫', '癲'),
			('篱', '籬'),
			('羁', '羈'),
			('蚕', '蠶'),
			('观', '觀'),
			('谗', '讒'),
			('让', '讓'),
			('谰', '讕'),
			('谶', '讖'),
			('赣', '贛'),
			('𨅬', '躝'),
			('酿', '釀'),
			('雳', '靂'),
			('霭', '靄'),
			('灵', '靈'),
			('颦', '顰'),
			('骤', '驟'),
			('鬓', '鬢'),
			('鹰', '鷹'),
			('鹭', '鷺'),
			('硷', '鹼'),
			('盐', '鹽'),
			('龋', '齲'),
			('龌', '齷'),
			('厅', '廳'),
			('榄', '欖'),
			('湾', '灣'),
			('箩', '籮'),
			('蛮', '蠻'),
			('蹑', '躡'),
			('钥', '鑰'),
			('镶', '鑲'),
			('颅', '顱'),
			('馋', '饞'),
			('瞩', '矚'),
			('躏', '躪'),
			('衅', '釁'),
			('驴', '驢'),
			('骥', '驥'),
			('缆', '纜'),
			('锣', '鑼'),
			('钻', '鑽'),
			('銮', '鑾'),
			('鳄', '鱷'),
			('鲈', '鱸'),
			('黩', '黷'),
			('戆', '戇'),
			('艳', '豔'),
			('凿', '鑿'),
			('鹦', '鸚'),
			('骊', '驪'),
			('鸾', '鸞'),
		])
	};
}
