use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub static ref HONG_KONG_VARIANT_MAP_SAFE: HashMap<char, char> = {
		HashMap::from([
			('倂', '併'),
			('僞', '偽'),
			('兌', '兑'),
			('册', '冊'),
			('删', '刪'),
			('匀', '勻'),
			('滙', '匯'),
			('叄', '叁'),
			('吿', '告'),
			('啟', '啓'),
			('塡', '填'),
			('姗', '姍'),
			('媼', '媪'),
			('嬀', '媯'),
			('幷', '并'),
			('悅', '悦'),
			('悳', '惪'),
			('慍', '愠'),
			('戶', '户'),
			('抛', '拋'),
			('挩', '捝'),
			('㨂', '揀'),
			('搵', '揾'),
			('敎', '教'),
			('敓', '敚'),
			('旣', '既'),
			('曁', '暨'),
			('栅', '柵'),
			('梲', '棁'),
			('槪', '概'),
			('榲', '榅'),
			('氳', '氲'),
			('汙', '污'),
			('没', '沒'),
			('洩', '泄'),
			('涗', '涚'),
			('溫', '温'),
			('潙', '溈'),
			('潨', '潀'),
			('溼', '濕'),
			('爲', '為'),
			('熅', '煴'),
			('床', '牀'),
			('奬', '獎'),
			('眞', '真'),
			('衆', '眾'),
			('硏', '研'),
			('稅', '税'),
			('緖', '緒'),
			('縕', '緼'),
			('駡', '罵'),
			('羣', '群'),
			('脫', '脱'),
			('膃', '腽'),
			('蔥', '葱'),
			('蒕', '蒀'),
			('蔿', '蒍'),
			('葯', '藥'),
			('蘊', '藴'),
			('蛻', '蜕'),
			('衛', '衞'),
			('裡', '裏'),
			('說', '説'),
			('艷', '豔'),
			('轀', '輼'),
			('醞', '醖'),
			('鉤', '鈎'),
			('銳', '鋭'),
			('錬', '鍊'),
			('鎭', '鎮'),
			('銹', '鏽'),
			('閱', '閲'),
			('鷄', '雞'),
			('鰮', '鰛'),
			('麵', '麪'),
		])
	};
}
