//! *Note: this project is still in development!*
//!
//! The API is subject to change (aka: it'll be easier to use by the first release!)
//!
//! <p align="center">
//!     <img width="30%" src="https://raw.githubusercontent.com/reaganmcf/woodland/master/assets/logo.png"/>
//! </p>
//!
//!
//! Easy to use implementations of popular tree data structures such as [`binary_tree::BinaryTree`],
//! [`AVLTree`], [`RedBlackTree`], and more.
//!
//! All implementations use Arena based tree structures in order to avoid the [mess that is accompanied when implementing graph-like structures in Rust](https://rust-leipzig.github.io/architecture/2016/12/20/idiomatic-trees-in-rust/). Not only is this mess avoided, but **all** of the tree implementations in `woodland` **can be used in multi-threaded contexts.**
//!
//! The inner workings are heavily inspired by [saschagrunert's `indextree`](https://github.com/saschagrunert/indextree)
//!
//!
//! ### What is an Arena / Index Tree?
//! Instead of linking nodes together using pointers, we instead use an identifier (in our case,
//! [`NodeId`] which references an key in a [`std::collections::HashMap`]). This isn't very interesting in other
//! languages, but it is particularly interesting in Rust since it's very messy and difficult to
//! implement tree's using traditional design patterns.
//!
//! The result is a **faster** and **concurrent** tree data structure, with a slightly different
//! API that is still easy to use!
//!
//! ### How to use
//! Each tree (such as [`binary_tree::BinaryTree`]) contains an example code block to get started
pub use crate::node::NodeId;

pub mod binary_tree;
mod node;
pub mod prelude;
mod tree;
