<p align='center'>
	<img width="250px" src="https://raw.githubusercontent.com/reaganmcf/woodland/master/assets/logo.png"/>	
</p>

# woodland
<p align="left">
  <img src="https://img.shields.io/static/v1?label=status&message=In%20Development&color=critical"/>
  <img src="https://github.com/reaganmcf/woodland/actions/workflows/ci.yml/badge.svg"/>
  <img src="https://img.shields.io/crates/v/woodland"/>
  <img src="https://shields.io/github/license/reaganmcf/woodland"/>
</p>

Easy to use implementations of popular tree data structures such as Binary, Binary Search, AVL, Red-Black, and more.

All implementations use Arena based tree structures in order to avoid the [mess that is accompanied when implementing graph-like structures in Rust](https://rust-leipzig.github.io/architecture/2016/12/20/idiomatic-trees-in-rust/). Not only is this mess avoided, but **all** of the tree implementations in `woodland` **can be used in multi-threaded contexts.**

The inner workings are heavily inspired by [saschagrunert's `indextree`](https://github.com/saschagrunert/indextree)

#### What is an Arena / Index tree?
Instead of linking nodes together using pointers, we instead use an identifier (in our case, `NodeId` which references a key in a `HashMap`). This isn't very interesting in other languages, but it is particular interesting in Rust since it's very messy and difficult to implement a Tree using traditional design patterns.

The result is a **faster** and **concurrent** tree data structure, with a slightly different API that is still easy to use!

## License
`woodland` uses the [MIT](https://choosealicense.com/licenses/mit/) license.

### Attributions

<div>Icons made by <a href="https://www.freepik.com" title="Freepik">Freepik</a> from <a href="https://www.flaticon.com/" title="Flaticon">www.flaticon.com</a></div>
