use std::collections::HashMap;
use wolfram_wxf::ToWolfram;

#[test]
fn test_basic() {
    assert_eq!(0u8.to_wolfram_bytes(), [56, 58, 67, 0]);
    assert_eq!(0u8.to_wolfram_solid(), [56, 67, 58, 120, 218, 115, 102, 0, 0, 0, 136, 0, 68]);

    let mut dict = HashMap::new();
    dict.insert(0, "zero");
    dict.insert(1, "first");
    dict.insert(2, "second");
    dict.insert(3, "third");
    dict.insert(4, "fourth");
    dict.insert(5, "fifth");
    debug_assert_eq!(
        dict.to_wolfram_bytes(),
        vec![
            56, 58, 65, 6, 45, 105, 0, 0, 0, 0, 83, 4, 122, 101, 114, 111, 45, 105, 1, 0, 0, 0, 83, 5, 102, 105, 114, 115, 116, 45, 105, 2, 0,
            0, 0, 83, 6, 115, 101, 99, 111, 110, 100, 45, 105, 3, 0, 0, 0, 83, 5, 116, 104, 105, 114, 100, 45, 105, 4, 0, 0, 0, 83, 6, 102,
            111, 117, 114, 116, 104, 45, 105, 5, 0, 0, 0, 83, 5, 102, 105, 102, 116, 104
        ]
    );
    debug_assert_eq!(
        dict.to_wolfram_solid(),
        vec![
            56, 67, 58, 120, 218, 45, 139, 201, 13, 192, 32, 12, 4, 115, 0, 221, 184, 136, 212, 144, 18, 18, 44, 239, 39, 150, 140, 243, 161,
            122, 14, 177, 175, 29, 141, 230, 74, 132, 173, 239, 14, 53, 155, 18, 246, 241, 35, 195, 138, 19, 142, 1, 169, 228, 71, 191, 151,
            112, 78, 229, 2, 235, 16, 166, 98, 253, 205, 133, 16, 87, 197, 46, 13, 222, 162, 19, 20
        ]
    );
}
