# Maintenance

This document describes steps required to maintain the `wolfram-app-discovery` project.

### `wolfram-app-discovery` command-line executable help text

This maintenance task should be run every time the `wolfram-app-discovery` command-line
interface changes.

The [`CommandLineHelp.md`](./CommandLineHelp.md) file contains the `--help` text for the
`wolfram-app-discovery` command-line tool. Storing this overview of the help text in a
markdown file makes the functionality of `wolfram-app-discovery` more discoverable, and
serves as an informal "cheet sheet" / reference material. Creation of the contents of
`CommandLineHelp.md` is partially automated by the undocumented `print-all-help`
subcommand:

```shell
$ wolfram-app-discovery print-all-help`
```

To update `CommandLineHelp.md`, perform the following steps:

1. Begin by deleting everything in `CommandLineHelp.md` after the line:

    <!-- BEGIN AUTOGENERATED CONTENT -->

2. Run `cargo build --features cli` to ensure `wolfram-app-discovery` is up to date.

3. Run `./target/debug/wolfram-app-discovery print-all-help --markdown | pbcopy` to print
   the help text formatted into readable markdown sections. On macOS, the `| pbcopy` will
   automatically copy this content to the clipboard.

4. Paste the markdown help text at the end of `CommandLineHelp.md`

5. Commit the updates with a commit message like: `chore: regenerate CommandLineHelp.md`
