# `wolfram-app-discovery` help text

This file contains the `--help` text for the `wolfram-app-discovery` command-line
executable.

*This file is regenerated periodically. See [Maintenance.md](./Maintenance.md) for details.*

<!-- BEGIN AUTOGENERATED CONTENT -->

### `wolfram-app-discovery --help`

```text
wolfram-app-discovery
Discovery local installations of the Wolfram Language and Wolfram products

USAGE:
    wolfram-app-discovery <SUBCOMMAND>

OPTIONS:
    -h, --help    Print help information

SUBCOMMANDS:
    default    Print the default Wolfram app
    list       List all locatable Wolfram apps
    inspect    Print information about a specified Wolfram application
    help       Print this message or the help of the given subcommand(s)

```

#### `wolfram-app-discovery default --help`

```text
wolfram-app-discovery-default
Print the default Wolfram app.

This method uses [`WolframApp::try_default()`] to locate the default app.

USAGE:
    wolfram-app-discovery default [OPTIONS]

OPTIONS:
        --app-type <APP_TYPES>
            Wolfram application types to include

            [possible values: mathematica, engine, desktop, player, player-pro, finance-platform,
            programming-lab, wolfram-alpha-notebook-edition]

        --debug
            Whether to print application information in the verbose Debug format

    -h, --help
            Print help information

```


#### `wolfram-app-discovery list --help`

```text
wolfram-app-discovery-list
List all locatable Wolfram apps

USAGE:
    wolfram-app-discovery list [OPTIONS]

OPTIONS:
        --app-type <APP_TYPES>    Wolfram application types to include [possible values:
                                  mathematica, engine, desktop, player, player-pro, finance-
                                  platform, programming-lab, wolfram-alpha-notebook-edition]
        --debug                   Whether to print application information in the verbose Debug
                                  format
    -h, --help                    Print help information

```


#### `wolfram-app-discovery inspect --help`

```text
wolfram-app-discovery-inspect
Print information about a specified Wolfram application

USAGE:
    wolfram-app-discovery inspect [OPTIONS] <APP_DIR>

ARGS:
    <APP_DIR>

OPTIONS:
        --debug    Whether to print application information in the verbose Debug format
    -h, --help     Print help information

```


