use crate::db::entities::prelude::*;
use crate::db::functions::insert::insert_sns_media;
use anyhow::Result;
use sea_orm::{ConnectionTrait, DatabaseConnection, Schema};

pub async fn create_entities(conn: &DatabaseConnection) -> Result<()> {
    // let conn = Database::connect(db_url).await?;
    let builder = conn.get_database_backend();
    let schema = Schema::new(builder);

    let create_project_stmt = builder.build(&schema.create_table_from_entity(ProjectEntity));
    let create_tags_stmt = builder.build(&schema.create_table_from_entity(TagEntity));
    let create_branch_stmt = builder.build(&schema.create_table_from_entity(BranchEntity));
    let create_hash_stmt = builder.build(&schema.create_table_from_entity(HashEntity));
    let create_message_stmt = builder.build(&schema.create_table_from_entity(MessageEntity));
    let create_socialmedia_stmt =
        builder.build(&schema.create_table_from_entity(SocialMediaEntity));
    let create_versions_stmt = builder.build(&schema.create_table_from_entity(VersionEntity));
    let create_owner_stmt = builder.build(&schema.create_table_from_entity(OwnerEntity));
    let create_changelog_stmt = builder.build(&schema.create_table_from_entity(ChangelogEntity));

    let create_table_project = conn.execute(create_project_stmt).await;

    match create_table_project {
        Ok(_) => (),
        Err(e) => println!("table creation unsuccessful - error {:?}", e),
    };

    let create_table_tags = conn.execute(create_tags_stmt).await;
    match create_table_tags {
        Ok(_) => (),
        Err(e) => println!("table creation unsuccessful - error {:?}", e),
    };

    let create_table_branch = conn.execute(create_branch_stmt).await;
    match create_table_branch {
        Ok(_) => (),
        Err(e) => println!("table creation unsuccessful - error {:?}", e),
    };

    let create_table_hash = conn.execute(create_hash_stmt).await;
    match create_table_hash {
        Ok(_) => (),
        Err(e) => println!("table creation unsuccessful - error {:?}", e),
    };

    let create_table_changelog = conn.execute(create_changelog_stmt).await;
    match create_table_changelog {
        Ok(_) => (),
        Err(e) => println!("table creation unsuccessful - error {:?}", e),
    };

    let create_table_socialmedia = conn.execute(create_socialmedia_stmt).await;
    match create_table_socialmedia {
        Ok(_) => insert_sns_media(conn).await?,
        Err(e) => println!("table creation unsuccessful - error {:?}", e),
    };

    let create_table_versions = conn.execute(create_versions_stmt).await;
    match create_table_versions {
        Ok(_) => (),
        Err(e) => println!("table creation unsuccessful - error {:?}", e),
    };

    let create_table_owner = conn.execute(create_owner_stmt).await;
    match create_table_owner {
        Ok(_) => (),
        Err(e) => println!("table creation unsuccessful - error {:?}", e),
    };

    let create_table_message = conn.execute(create_message_stmt).await;
    match create_table_message {
        Ok(_) => (),
        Err(e) => println!("table creation unsuccessful - error {:?}", e),
    };

    Ok(())
}

// pub async fn drop_entities(conn: &DatabaseConnection) -> Result<()> {
//     // let conn = Database::connect(db_url).await?;
//     let builder = conn.get_database_backend();
//     let schema = Schema::new(builder);

//     let create_project_stmt = builder.build(&schema.create_table_from_entity(ProjectEntity));
//     let create_tags_stmt = builder.build(&schema.create_table_from_entity(TagEntity));
//     let create_branch_stmt = builder.build(&schema.create_table_from_entity(BranchEntity));
//     let create_hash_stmt = builder.build(&schema.create_table_from_entity(HashEntity));
//     let create_message_stmt = builder.build(&schema.create_table_from_entity(MessageEntity));
//     let create_socialmedia_stmt =
//         builder.build(&schema.create_table_from_entity(SocialMediaEntity));
//     let create_versions_stmt = builder.build(&schema.create_table_from_entity(VersionEntity));
//     let create_owner_stmt = builder.build(&schema.create_table_from_entity(OwnerEntity));
//     let create_changelog_stmt = builder.build(&schema.create_table_from_entity(ChangelogEntity));

//     let create_table_project = conn.execute(create_project_stmt).await;

//     match create_table_project {
//         Ok(_) => (),
//         Err(e) => println!("table creation unsuccessful - error {:?}", e),
//     };

//     let create_table_tags = conn.execute(create_tags_stmt).await;
//     match create_table_tags {
//         Ok(_) => (),
//         Err(e) => println!("table creation unsuccessful - error {:?}", e),
//     };

//     let create_table_branch = conn.execute(create_branch_stmt).await;
//     match create_table_branch {
//         Ok(_) => (),
//         Err(e) => println!("table creation unsuccessful - error {:?}", e),
//     };

//     let create_table_hash = conn.execute(create_hash_stmt).await;
//     match create_table_hash {
//         Ok(_) => (),
//         Err(e) => println!("table creation unsuccessful - error {:?}", e),
//     };

//     let create_table_message = conn.execute(create_message_stmt).await;
//     match create_table_message {
//         Ok(_) => (),
//         Err(e) => println!("table creation unsuccessful - error {:?}", e),
//     };

//     let create_table_socialmedia = conn.execute(create_socialmedia_stmt).await;
//     match create_table_socialmedia {
//         Ok(_) => (),
//         Err(e) => println!("table creation unsuccessful - error {:?}", e),
//     };

//     let create_table_versions = conn.execute(create_versions_stmt).await;
//     match create_table_versions {
//         Ok(_) => (),
//         Err(e) => println!("table creation unsuccessful - error {:?}", e),
//     };

//     let create_table_owner = conn.execute(create_owner_stmt).await;
//     match create_table_owner {
//         Ok(_) => (),
//         Err(e) => println!("table creation unsuccessful - error {:?}", e),
//     };

//     let create_table_changelog = conn.execute(create_changelog_stmt).await;
//     match create_table_changelog {
//         Ok(_) => (),
//         Err(e) => println!("table creation unsuccessful - error {:?}", e),
//     };

//     Ok(())
// }
