CREATE TABLE IF NOT EXISTS project (
    id INTEGER PRIMARY KEY NOT NULL,
    -- name TEXT PRIMARY KEY NOT NULL,
    name VARCHAR(32) NOT NULL,
    description TEXT NOT NULL,
    url VARCHAR(64) NOT NULL,
    emoji VARCHAR(1) NOT NULL,
    is_featured TINYINT NOT NULL CHECK (is_featured IN (0, 1)),
    is_template TINYINT NOT NULL CHECK (is_template IN (0, 1)),
    UNIQUE(id, name)
);
CREATE UNIQUE INDEX IF NOT EXISTS project_idx ON project(id);
CREATE UNIQUE INDEX IF NOT EXISTS project_name_idx ON project(name);
-- branch
CREATE TABLE IF NOT EXISTS branch (
    name VARCHAR(16) NOT NULL,
    project_id INTEGER NOT NULL,
    FOREIGN KEY (project_id) REFERENCES project(id),
    UNIQUE(project_id)
);
CREATE UNIQUE INDEX IF NOT EXISTS branch_project_idx ON branch(project_id);
-- tag
CREATE TABLE IF NOT EXISTS tag (
    name VARCHAR(16) NOT NULL,
    project_id INTEGER NOT NULL,
    FOREIGN KEY (project_id) REFERENCES project(id) PRIMARY KEY (name, project_id)
);
CREATE INDEX IF NOT EXISTS tag_project_idx ON tag(project_id);
-- changelog
CREATE TABLE IF NOT EXISTS changelog (
    project_id INTEGER NOT NULL,
    hash VARCHAR(64) NOT NULL,
    prev_hash VARCHAR(64) NOT NULL,
    FOREIGN KEY (project_id) REFERENCES project(id),
    FOREIGN KEY (hash) REFERENCES hash(id),
    FOREIGN KEY (prev_hash) REFERENCES hash(id),
    UNIQUE(project_id, hash)
);
CREATE UNIQUE INDEX IF NOT EXISTS changelog_project_idx ON changelog(project_id);
CREATE UNIQUE INDEX IF NOT EXISTS changelog_hash_idx ON changelog(hash);
-- hash
CREATE TABLE IF NOT EXISTS hash (
    id VARCHAR(64) PRIMARY KEY,
    data TEXT NOT NULL,
    UNIQUE(id)
);
--owner
CREATE TABLE IF NOT EXISTS owner (
    tag VARCHAR(32) PRIMARY KEY,
    project_id INTEGER NOT NULL,
    name VARCHAR(64) NOT NULL,
    email VARCHAR(100),
    is_n3nx_member TINYINT NOT NULL CHECK (is_n3nx_member IN (0, 1)),
    commit_count INTEGER NOT NULL,
    FOREIGN KEY (project_id) REFERENCES project(id),
    UNIQUE(tag)
);
CREATE UNIQUE INDEX IF NOT EXISTS owner_tag_idx ON owner(tag);
CREATE INDEX IF NOT EXISTS owner_project_idx ON owner(project_id);
--version
CREATE TABLE IF NOT EXISTS version (
    project_id INTEGER NOT NULL,
    hash VARCHAR(64) NOT NULL,
    timestamp TIMESTAMP NOT NULL,
    name VARCHAR(16) NOT NULL,
    major TINYINT NOT NULL,
    minor TINYINT NOT NULL,
    patch TINYINT NOT NULL,
    codename VARCHAR(32),
    start_commit VARCHAR(40),
    end_commit VARCHAR(40),
    FOREIGN KEY (project_id) REFERENCES project(id),
    FOREIGN KEY (hash) REFERENCES hash(id),
    UNIQUE(hash)
);
CREATE INDEX IF NOT EXISTS version_project_idx ON version(project_id);
CREATE UNIQUE INDEX IF NOT EXISTS version_hash_idx ON version(hash);
--message
CREATE TABLE IF NOT EXISTS message (
    social_media_id INTEGER NOT NULL,
    project_id INTEGER NOT NULL,
    version_hash VARCHAR(64) NOT NULL,
    timestamp TIMESTAMP NOT NULL,
    message_id VARCHAR(32) NOT NULL,
    message_hash VARCHAR(64) NOT NULL,
    FOREIGN KEY (project_id) REFERENCES project(id),
    FOREIGN KEY (social_media_id) REFERENCES social_media(id),
    FOREIGN KEY (version_hash) REFERENCES hash(id),
    UNIQUE(social_media_id, message_hash)
);
CREATE INDEX IF NOT EXISTS message_project_idx ON message(project_id);
CREATE INDEX IF NOT EXISTS message_version_hash_idx ON message(version_hash);
-- --media
CREATE TABLE IF NOT EXISTS social_media (
    id INTEGER PRIMARY KEY NOT NULL,
    platform_name VARCHAR(16) NOT NULL,
    UNIQUE(id, platform_name)
);
CREATE INDEX IF NOT EXISTS social_media_platform_name ON social_media(id);
INSERT OR IGNORE INTO social_media(platform_name) VALUES ("telegram"), ("twitter"), ("reddit"), ("discord"), ("linkedin"), ("slack");