#!/usr/bin/env bash
######################################################################
#
# add_rust_lang.sh - Install Rust toolchain for the project.
#
# Copyright 2020-2021 Naman Bishnoi
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
######################################################################
set -euxo

echo "**********************************************************************"
echo "Installing Rustup v%%RUSTUP_VERSION%%"
echo "**********************************************************************"
dpkgArch="$(dpkg --print-architecture)"; 
    case "${dpkgArch##*-}" in 
        amd64) rustArch='x86_64-unknown-linux-gnu'; rustupSha256='3dc5ef50861ee18657f9db2eeb7392f9c2a6c95c90ab41e45ab4ca71476b4338' ;; 
        *) echo >&2 "unsupported architecture: ${dpkgArch}"; exit 1 ;; 
    esac
# Download the Rustup installer script
url="https://static.rust-lang.org/rustup/archive/1.24.3/${rustArch}/rustup-init"
curl -O "$url"

# Verify Rustup checksum for integrity
echo "${rustupSha256} *rustup-init" | sha256sum -c -

# Make Rustup executable
chmod +x rustup-init

echo "**********************************************************************"
echo "Installing Rust v1.59.0"
echo "**********************************************************************"
RUSTUP_HOME=/usr/local/rustup \
    CARGO_HOME=/usr/local/cargo \
    PATH=/usr/local/cargo/bin:$PATH \
    ./rustup-init -y --no-modify-path --profile minimal --default-toolchain 1.59.0 --default-host ${rustArch}
rm rustup-init

# Grants permission for particular directories
chmod -R a+w /usr/local/rustup /usr/local/cargo

echo "**********************************************************************"
echo "Installation Completed"
echo "**********************************************************************"
rustup --version
cargo --version
rustc --version
