mod api;
mod cache;
mod consts;
mod core;
mod db;
mod utils;

use crate::core::models::Config;
use crate::core::runner::*;

use crate::consts::{
    DEFAULT_CONFIG_DIR, DEFAULT_CONFIG_PATH, N3NX_ABOUT_PROJECT, N3NX_PROJECT_AUTHORS,
    N3NX_PROJECT_NAME, N3NX_PROJECT_VERSION, N3N_WOLF_LOGO, PROJECT_URL, WOLFIE_BANNER,
};
use clap::{Arg, Command};
use colored::*;
use std::fs::{create_dir, read_to_string};

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    let wolf_logo = N3N_WOLF_LOGO.truecolor(242, 175, 41);
    let wolfie_banner = WOLFIE_BANNER.truecolor(235, 248, 184);
    let project_version = N3NX_PROJECT_VERSION.white();
    let project_name = N3NX_PROJECT_NAME;
    let project_version_noncol = N3NX_PROJECT_VERSION;
    let project_authors = N3NX_PROJECT_AUTHORS;
    let about_project = N3NX_ABOUT_PROJECT;

    println!("{}", wolf_logo);
    println!("{} v{}\n", wolfie_banner, project_version);
    println!("{:13}{}", " ", PROJECT_URL);

    let matches = Command::new(project_name)
        .version(project_version_noncol)
        .author(project_authors)
        .about(about_project)
        .arg(
            Arg::new("config")
                .help("Sets a config file to use")
                .index(1),
        )
        .get_matches();

    create_dir(&*DEFAULT_CONFIG_DIR).unwrap_or(());

    let config = matches.value_of("config").unwrap_or(&DEFAULT_CONFIG_PATH);
    let raw_config = read_to_string(config)?;
    let config: Config = toml::from_str(&raw_config)?;

    start_sync(&config).await?;

    Ok(())
}
