use sea_orm::entity::prelude::*;

#[derive(Clone, Debug, PartialEq, DeriveEntityModel)]
#[sea_orm(table_name = "version")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub project_id: String,
    #[sea_orm(primary_key)]
    pub hash: String,
    pub timestamp: DateTimeUtc,
    pub name: String,
    pub major: i32,
    pub minor: i32,
    pub patch: i32,
    pub codename: Option<String>,
    pub start_commit: Option<String>,
    pub end_commit: Option<String>,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(
        belongs_to = "super::hash::Entity",
        from = "Column::Hash",
        to = "super::hash::Column::Id",
        on_update = "Cascade",
        on_delete = "Cascade"
    )]
    Hash,
    #[sea_orm(
        belongs_to = "super::project::Entity",
        from = "Column::ProjectId",
        to = "super::project::Column::Name",
        on_update = "Cascade",
        on_delete = "Cascade"
    )]
    Project,
}

impl Related<super::hash::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Hash.def()
    }
}

impl Related<super::project::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Project.def()
    }
}

impl ActiveModelBehavior for ActiveModel {}
