use sea_orm::entity::prelude::*;

#[derive(Clone, Debug, PartialEq, DeriveEntityModel)]
#[sea_orm(table_name = "changelog")]
pub struct Model {
    #[sea_orm(primary_key, unique, auto_increment = false)]
    pub project_id: String,
    pub hash: String,
    pub prev_hash: String,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(
        belongs_to = "super::hash::Entity",
        from = "Column::PrevHash",
        to = "super::hash::Column::Id",
        on_update = "Cascade",
        on_delete = "Cascade"
    )]
    Hash2,
    #[sea_orm(
        belongs_to = "super::hash::Entity",
        from = "Column::Hash",
        to = "super::hash::Column::Id",
        on_update = "Cascade",
        on_delete = "Cascade"
    )]
    Hash1,
    #[sea_orm(
        belongs_to = "super::project::Entity",
        from = "Column::ProjectId",
        to = "super::project::Column::Name",
        on_update = "Cascade",
        on_delete = "Cascade"
    )]
    Project,
}

impl Related<super::project::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Project.def()
    }
}

impl ActiveModelBehavior for ActiveModel {}
