use sea_orm::entity::prelude::*;

#[derive(Clone, Debug, PartialEq, DeriveEntityModel)]
#[sea_orm(table_name = "project")]
pub struct Model {
    #[sea_orm(primary_key, unique)]
    pub id: u32,
    #[sea_orm(unique)]
    pub name: String,
    pub description: String,
    pub url: String,
    pub emoji: String,
    pub is_featured: bool,
    pub is_template: bool,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(has_many = "super::branch::Entity")]
    Branch,
    #[sea_orm(has_many = "super::tag::Entity")]
    Tag,
    #[sea_orm(has_many = "super::changelog::Entity")]
    Changelog,
    #[sea_orm(has_many = "super::owner::Entity")]
    Owner,
    #[sea_orm(has_many = "super::version::Entity")]
    Version,
    #[sea_orm(has_many = "super::message::Entity")]
    Message,
}

impl Related<super::branch::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Branch.def()
    }
}

impl Related<super::tag::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Tag.def()
    }
}

impl Related<super::changelog::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Changelog.def()
    }
}

impl Related<super::owner::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Owner.def()
    }
}

impl Related<super::version::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Version.def()
    }
}

impl Related<super::message::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Message.def()
    }
}

impl ActiveModelBehavior for ActiveModel {}
