use sea_orm::entity::prelude::*;

#[derive(Clone, Debug, PartialEq, DeriveEntityModel)]
#[sea_orm(table_name = "message")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub social_media_id: u8,
    #[sea_orm(primary_key)]
    pub project_id: u32,
    pub version_hash: String,
    pub timestamp: DateTimeUtc,
    pub message_id: String,
    pub message_hash: String,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(
        belongs_to = "super::hash::Entity",
        from = "Column::VersionHash",
        to = "super::hash::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    Hash,
    #[sea_orm(
        belongs_to = "super::social_media::Entity",
        from = "Column::SocialMediaId",
        to = "super::social_media::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    SocialMedia,
    #[sea_orm(
        belongs_to = "super::project::Entity",
        from = "Column::ProjectId",
        to = "super::project::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    Project,
}

impl Related<super::hash::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Hash.def()
    }
}

impl Related<super::social_media::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::SocialMedia.def()
    }
}

impl Related<super::project::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Project.def()
    }
}

impl ActiveModelBehavior for ActiveModel {}
