# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.4.0] - 2022-03-01

[0.4.0]: ../../../compare/ed5ebdebe7023bff02eb0c8e314c11e4453f7d74...b109b7ef165c4d33c2622138c6cc20a5ae7d0f0d

### Bug Fixes

- *core:* Fix async thread fetching from runner ([7089138](708913841df50f1e321657358f05a51ba9af3088))
- *runner:* Ignore if overwriting existing entry in db ([b109b7e](b109b7ef165c4d33c2622138c6cc20a5ae7d0f0d))
- *schema:* Fix entity creation error handling ([e4abcd3](e4abcd3ce751e636c2c29e041eac261134054ac5))
- *wolfie:* Fix deprecation  in replacement for ([1a72fd7](1a72fd7b9667fb3a96cf604b0fe52e7065f0f787))

### Features

- *db:* Add sea-orm for query building and db migration features ([291ba68](291ba684dfb99198d25fc3978c6c65d9cd154721))
- *memory:* Add cache storage from memory for fast retrieval ([4abc933](4abc9333e1cf255c49f3f48e4071a21a88896ffc))

### Improvements

- *cache:* Upgrade to rkv integrated key value store ([6b6f7e0](6b6f7e074f3f0a0efb7227394fd75cbf1d9f989d))
- *wolfie:* Add github fetch direct feature in wolfie [#3] ([29c5d3b](29c5d3b52daa698cf1c5030b11bb75ff422ea099))

<!-- CHANGELOG SPLIT MARKER -->
## [0.3.0] - 2021-12-13

[0.3.0]: ../../../compare/72b9775e2f81e1447efb53ed98a54082de1d469b...ed5ebdebe7023bff02eb0c8e314c11e4453f7d74

### Bug Fixes

- *api:* Fix `message_id` type to string to generalize future apis ([f7f18e0](f7f18e0770b5be0bc0c0367e5f39f61a3cf01842))
- *main:* Fix default config file requirement ([fa4885b](fa4885b3cf19bf9647b8548f1a19c991c929eb89))
- *wolfie:* Fix adapter storage sync and add config defaults ([71c95e3](71c95e3a0231aca0003be132baf783ef71a34562))

### Features

- *api:* Add discord api support for wolfie publisher ([4ba1179](4ba1179a36cc94a68bb8f99d8e8c94b6525c0baa))
- *db:* Add adapter trait for `SocialBox`es with new database apis ([229a012](229a012bea57f30439aa3c97768049fb1fdf5b58))

### Improvements

- *api:* Implement telegram and twitter publisher functions ([377e5ad](377e5addef787783517eb5653e85fa5793353c9a))
- *api:* Add publisher implementation for twitter api ([8a11237](8a11237e524f6f4f58ab5868341f577058337772))
- *db:* Improve by using single db connection for each instance ([c7ae24b](c7ae24b5618cde5fdbd74f7a00a39ec1e51b8574))
- *wolfie:* Improve wolfie core and db to use epoch timestamp for date ([e4914c6](e4914c6e570d5c0140ee5e817225da4d8917c3a4))

### Refactoring Updates

- *api:* Refactor config substructs to non-generic names ([a3206c9](a3206c95fa56d869057075f2e672d67b90db69a2))
- *wolfie:* Refactor all apis according to their providers in codebase ([7e225a8](7e225a8448730ce8de4ebedce298f89e6ac658c8))

<!-- CHANGELOG SPLIT MARKER -->
## [0.2.1] - 2021-12-10

[0.2.1]: ../../../compare/b80d2ed6948106970ebcdd22a279e6e6f11fe095...72b9775e2f81e1447efb53ed98a54082de1d469b

### Improvements

- *core:* Optimize social runner to prioritize in-memory objects first ([6da4be1](6da4be10f085c9a79fc465ce614a64907322cfd2))
- *wolfie:* Improve cli aesthetics for more friendly look ([a92c923](a92c923f77dcc84acbf2e4af04ca5d211257acdd))

<!-- CHANGELOG SPLIT MARKER -->
## [0.2.0] - 2021-12-09

[0.2.0]: ../../../compare/9c087fa14def753c2f93c28486e857aac7b85e8a...b80d2ed6948106970ebcdd22a279e6e6f11fe095

### Bug Fixes

- *db:* Fix query for `get_versions` for respective projects ([540263d](540263d8d01699ac7107d568f270026240191db1))

### Extra Tasks

- *cargo:* Update `sha2` to v0.10.0 ([c921d7e](c921d7eaad21bb69c5e2a4ba05b8109ab8ba6df6))

### Features

- *db:* Add database features for wolfie data integrity ([c387eb6](c387eb65ac33bdad01d3de10d99f315570e5cff3))
- *db:* Add database handling functions and queries for controllers ([25b4892](25b4892750f437787049c779a994eee549543a33))

### Improvements

- *builder:* Improve builder to use database queries and objects for posts ([d1d7d87](d1d7d873603a0bb63b0d94f096aa1592eb6beab5))
- *core:* Upgrade wolfie core for timed data fetch and high performance ([e3bbe1b](e3bbe1b4bbe8effcc20cece189102ca0b3fffb12))

### Refactoring Updates

- *core:* Remove all declarations of twitter apis from runner ([7e41bd4](7e41bd44d7bf7ba4369ee5af05f6dd9024a6f24d))
- *core:* Change fetch_time `PERIOD` from 1 minute to 30 minutes ([725d209](725d20972f400dc650bcb1126e0557cd88a6d7bc))

<!-- CHANGELOG SPLIT MARKER -->
## [0.1.0] - 2021-12-01

[0.1.0]: ../../../releases/tag/v0.1.0

### Bug Fixes

- *log:* Remove template projects from apis queue with empty body fix ([a4787e1](a4787e1ed70b9c18816fc55c90abba3a29a6c64f))

### Documentation

- *wolfie:* Update project tags in `readme.md` file and `Cargo.toml` ([bdc4af7](bdc4af7d2e13ca9305620725a675fecd2c96613e))

### Features

- *api:* Add twitter api client and add generics `SocialBox` ([cd4740d](cd4740d413cc61bbe2402b88f9da8b1f90d03d21))

### Improvements

- *api:* Optimize api models for streamlining apps ([03bcb46](03bcb4682bc1b37bceaa4ba9148d46de5309a0fe))
- *builder:* Add tweet and telegram message builder with few refactors ([26a372c](26a372c43b2d06ce159ea8b38b56764bd73c9c4f))
- *parser:* Add project emoji in telegram message headers ([ff0ce81](ff0ce814a9e51640ecfb4b4806abf161367d9176))

### Styling

- *wolfie:* Prettify api, log and models file ([fd695f3](fd695f37d8849d33fe0e29a14d4154945104ef45))

<!-- CHANGELOG SPLIT MARKER -->
