use anyhow::Result;
use rusqlite::Connection;
use std::fs::read_to_string;

#[allow(dead_code)]
pub fn create_database(conn: &Connection) -> Result<()> {
    let queries = read_to_string("./src/db/migrations/up.sql")?;
    conn.execute_batch(&queries)?;
    Ok(())
}

#[allow(dead_code)]
pub fn drop_database(conn: &Connection) -> Result<()> {
    let queries = read_to_string("./src/db/migrations/down.sql")?;
    conn.execute_batch(&queries)?;
    Ok(())
}
