use crate::core::models::{Changelog, MediaId, Message, Project, Version};
use anyhow::Result;
use rusqlite::{params, Connection};

#[allow(dead_code)]
pub fn delete_prev_changelog(conn: &Connection, changelog: &Changelog) -> Result<()> {
    conn.execute(
        "DELETE FROM hash WHERE id = (SELECT prev_hash FROM changelog WHERE hash = ?)",
        params![changelog.hash],
    )?;
    Ok(())
}

#[allow(dead_code)]
pub fn delete_current_changelog(conn: &Connection, changelog: &Changelog) -> Result<()> {
    conn.execute("DELETE FROM hash WHERE id = ?", params![changelog.hash])?;
    Ok(())
}

#[allow(dead_code)]
pub fn delete_version(conn: &Connection, version: &Version) -> Result<()> {
    conn.execute("DELETE FROM hash WHERE id = ?", params![version.hash])?;
    conn.execute("DELETE FROM version WHERE hash = ?", params![version.hash])?;

    Ok(())
}

pub fn delete_project(conn: &Connection, project: &Project) -> Result<()> {
    // Delete all version hashes
    conn.execute("DELETE FROM hash WHERE id IN (SELECT hash FROM version WHERE project_id = (SELECT id FROM project WHERE name = ?))", params![project.name])?;

    // Delete all versions
    conn.execute(
        "DELETE FROM version WHERE project_id = (SELECT id FROM project WHERE name = ?)",
        params![project.name],
    )?;

    // Delete previous logs and next logs
    conn.execute("DELETE FROM hash WHERE id = (SELECT prev_hash FROM changelog WHERE project_id = (SELECT id FROM project WHERE name = ?))", params![project.name])?;
    conn.execute("DELETE FROM hash WHERE id = (SELECT hash FROM changelog WHERE project_id = (SELECT id FROM project WHERE name = ?))", params![project.name])?;

    // Delete changelog associated with project
    conn.execute(
        "DELETE FROM changelog where project_id = (SELECT id FROM project WHERE name = ?)",
        params![project.name],
    )?;

    // Delete associated branch with project
    conn.execute(
        "DELETE FROM branch WHERE project_id = (SELECT id FROM project WHERE name = ?)",
        params![project.name],
    )?;

    // Delete associated tags with project
    conn.execute(
        "DELETE FROM tag WHERE project_id = (SELECT id FROM project WHERE name = ?)",
        params![project.name],
    )?;

    // Delete project entry
    conn.execute("DELETE FROM project WHERE name = ?", params![project.name])?;
    Ok(())
}

pub fn delete_message(conn: &Connection, media: MediaId, message: &Message) -> Result<()> {
    let platform_name: &str = media.into();

    conn.execute("DELETE FROM message WHERE social_media_id = (SELECT id FROM social_media WHERE platform_name = ?1) AND message_id = ?2", params![platform_name, message.message_id])?;
    Ok(())
}
