use lazy_static::lazy_static;

/***************************/
/*-------------------------*/
/*--                     --*/
/*--  Project Metadata   --*/
/*--                     --*/
/*-------------------------*/
/***************************/
pub const N3NX_PROJECT_NAME: &str = "N3NX Micro Project Logger and News Delivery Service";
pub const N3NX_ABOUT_PROJECT: &str = "Delivers latest N3NX projects news all around the world.";
pub const PROJECT_URL: &str = "https://api.n3n.org";
pub const N3NX_PROJECT_VERSION: &str = env!("CARGO_PKG_VERSION");
pub const N3NX_PROJECT_AUTHORS: &str = env!("CARGO_PKG_AUTHORS");

/***************************/
/*-------------------------*/
/*--                     --*/
/*--   Config Defaults   --*/
/*--                     --*/
/*-------------------------*/
/***************************/
pub const DEFAULT_SCAN_PERIOD: u64 = 30;
lazy_static! {
    pub static ref DEFAULT_DB_PATH: String = format!("{}/.wolfie/n3nx.db", env!("HOME"));
    pub static ref DEFAULT_CONFIG_PATH: String = format!("{}/.wolfie/config.toml", env!("HOME"));
    pub static ref DEFAULT_CONFIG_DIR: String = format!("{}/.wolfie/", env!("HOME"));
}

/***************************/
/*-------------------------*/
/*--                     --*/
/*--    N3NX Banners     --*/
/*--                     --*/
/*-------------------------*/
/***************************/
pub const N3N_WOLF_LOGO: &str = "
                                         TM
      ;o;.                          .;o;             
      oKkdc.          ..          .cdkXo             
      ox..:ol,   .;llccccll;.   ,lo:..xo             
      od.  .,oocldc'.    .'cdlcoo,.  .do             
      od.    'x00d'        'd00x'    .do             
      od.  .cdc..;oo;    ;oo;..cdc.  .do             
      od..cdc.     ck;  ;kc     .cdc..do             
      oOx0Kxcccccl';k;  ;k,'lcccccxK0xOo             
      oXOkOd;'..;ko;k;  ;k;ok;...;oOOOXo             
      ok'.,loc' .do;k;  ;k;od. 'col,.'Oo             
      lx.   .;oooOl;k;  ;k;oOooo;.   .xl             
      'xl.     .l0o;k;  ;k;o0l.     .lx.             
       .od;     .xl;k;  ;k;ox.     ;do.              
         ,oo;   .xo;k;  ;k;od.   ;oo,                
           'oo; .do;k;  ;x;od. ;oo,                  
             ,oolkl;k:  :k;okloo,                    
               'dKo;O0xx0O;oKd,                      
                 lxdKMMMMKdxc                        
                  ;xKWWWWKx;                         
                    .,,,,.                           
";

pub const WOLFIE_BANNER: &str = r"
                      _  __ _      
       __      _____ | |/ _(_) ___ 
       \ \ /\ / / _ \| | |_| |/ _ \
        \ V  V / (_) | |  _| |  __/
         \_/\_/ \___/|_|_| |_|\___|";
