mod api;
mod builder;
mod consts;
mod core;
mod db;

// use crate::consts::;
use crate::core::models::Config;
use crate::core::runner::*;

use clap::{App, Arg};
use colored::*;
use std::fs::read_to_string;

fn main() -> Result<(), Box<dyn std::error::Error>> {
    let wolf_logo = consts::N3N_WOLF_LOGO.truecolor(242, 175, 41);
    let wolfie_banner = consts::WOLFIE_BANNER.truecolor(235, 248, 184);
    let project_version = consts::N3NX_PROJECT_VERSION.white();
    let project_name = consts::N3NX_PROJECT_NAME;
    let project_version_noncol = consts::N3NX_PROJECT_VERSION;
    let project_authors = consts::N3NX_PROJECT_AUTHORS;
    let about_project = consts::N3NX_ABOUT_PROJECT;

    println!("{}", wolf_logo);
    println!("{} v{}\n", wolfie_banner, project_version);
    println!("{:13}{}", " ", consts::PROJECT_URL);

    let matches = App::new(project_name)
        .version(project_version_noncol)
        .author(project_authors)
        .about(about_project)
        .arg(
            Arg::with_name("config")
                .help("Sets a config file to use")
                .required(true)
                .index(1),
        )
        .get_matches();

    let config = matches.value_of("config").unwrap_or("default.conf");
    let raw_config = read_to_string(config)?;
    let config: Config = toml::from_str(&raw_config).unwrap();

    start_sync(&config)?;

    Ok(())
}
