use anyhow::Result;
use rusqlite::Connection;
use std::fs::read_to_string;

#[allow(dead_code)]
pub fn create_database(path: &str) -> Result<()> {
    let conn = Connection::open(path)?;
    let queries = read_to_string("./src/db/migrations/create.sql")?;
    conn.execute_batch(&queries)?;
    Ok(())
}

#[allow(dead_code)]
pub fn drop_database(path: &str) -> Result<()> {
    let conn = Connection::open(path)?;
    let queries = read_to_string("./src/db/migrations/delete.sql")?;
    conn.execute_batch(&queries)?;
    Ok(())
}
