CREATE TABLE IF NOT EXISTS project (
    id INTEGER PRIMARY KEY NOT NULL,
    -- name TEXT PRIMARY KEY NOT NULL,
    name TEXT NOT NULL,
    description TEXT NOT NULL,
    url TEXT NOT NULL,
    emoji TEXT NOT NULL,
    is_featured INTEGER NOT NULL CHECK (is_featured IN (0, 1)),
    is_template INTEGER NOT NULL CHECK (is_template IN (0, 1)),
    UNIQUE(id, name)
);
CREATE UNIQUE INDEX IF NOT EXISTS project_idx ON project(id);
CREATE UNIQUE INDEX IF NOT EXISTS project_name_idx ON project(name);
-- branch
CREATE TABLE IF NOT EXISTS branch (
    name TEXT NOT NULL,
    project_id INTEGER NOT NULL,
    FOREIGN KEY (project_id) REFERENCES project(id),
    UNIQUE(project_id)
);
CREATE UNIQUE INDEX IF NOT EXISTS branch_project_idx ON branch(project_id);
-- tag
CREATE TABLE IF NOT EXISTS tag (
    name TEXT NOT NULL,
    project_id INTEGER NOT NULL,
    FOREIGN KEY (project_id) REFERENCES project(id)
    PRIMARY KEY (name, project_id)
);
CREATE INDEX IF NOT EXISTS tag_project_idx ON tag(project_id);
-- changelog
CREATE TABLE IF NOT EXISTS changelog (
    project_id INTEGER NOT NULL,
    hash TEXT NOT NULL,
    prev_hash TEXT NOT NULL,
    FOREIGN KEY (project_id) REFERENCES project(id),
    FOREIGN KEY (hash) REFERENCES hash(id),
    FOREIGN KEY (prev_hash) REFERENCES hash(id),
    UNIQUE(project_id, hash)
);
CREATE UNIQUE INDEX IF NOT EXISTS changelog_project_idx ON changelog(project_id);
CREATE UNIQUE INDEX IF NOT EXISTS changelog_hash_idx ON changelog(hash);
-- hash
CREATE TABLE IF NOT EXISTS hash (
    id TEXT PRIMARY KEY,
    data TEXT NOT NULL,
    UNIQUE(id)
);
--owner
CREATE TABLE IF NOT EXISTS owner (
    tag TEXT PRIMARY KEY,
    project_id INTEGER NOT NULL,
    name TEXT NOT NULL,
    email TEXT,
    is_n3nx_member INTEGER NOT NULL CHECK (is_n3nx_member IN (0, 1)),
    commit_count INTEGER NOT NULL,
    FOREIGN KEY (project_id) REFERENCES project(id),
    UNIQUE(tag)
);
CREATE UNIQUE INDEX IF NOT EXISTS owner_tag_idx ON owner(tag);
CREATE INDEX IF NOT EXISTS owner_project_idx ON owner(project_id);
--version
CREATE TABLE IF NOT EXISTS version (
    -- id INTEGER PRIMARY KEY,
    -- changelog_id INTEGER NOT NULL,
    project_id INTEGER NOT NULL,
    hash TEXT NOT NULL,
    release_date TIMESTAMP NOT NULL,
    name TEXT NOT NULL,
    major INTEGER NOT NULL,
    minor INTEGER NOT NULL,
    patch INTEGER NOT NULL,
    codename TEXT,
    start_commit TEXT,
    end_commit TEXT,
    FOREIGN KEY (project_id) REFERENCES project(id),
    -- FOREIGN KEY (changelog_id) REFERENCES changelog(id),
    FOREIGN KEY (hash) REFERENCES hash(id),
    UNIQUE(hash)
);
-- CREATE INDEX IF NOT EXISTS version_idx ON version(id);
CREATE INDEX IF NOT EXISTS version_project_idx ON version(project_id);
-- CREATE INDEX IF NOT EXISTS version_changelog_idx ON version(changelog_id);
CREATE UNIQUE INDEX IF NOT EXISTS version_hash_idx ON version(hash);