use crate::core::models::{Changelog, Project, Version};
use anyhow::Result;
use rusqlite::{params, Connection};

#[allow(dead_code)]
pub fn delete_prev_changelog(path: &str, changelog: &Changelog) -> Result<()> {
    let conn = Connection::open(&path)?;
    conn.execute(
        "DELETE FROM hash WHERE id = (SELECT prev_hash FROM changelog WHERE hash = ?)",
        params![changelog.hash],
    )?;
    Ok(())
}

#[allow(dead_code)]
pub fn delete_current_changelog(path: &str, changelog: &Changelog) -> Result<()> {
    let conn = Connection::open(&path)?;
    conn.execute("DELETE FROM hash WHERE id = ?", params![changelog.hash])?;
    Ok(())
}

#[allow(dead_code)]
pub fn delete_version(path: &str, version: &Version) -> Result<()> {
    let conn = Connection::open(&path)?;

    conn.execute("DELETE FROM hash WHERE id = ?", params![version.hash])?;
    conn.execute("DELETE FROM version WHERE hash = ?", params![version.hash])?;

    Ok(())
}

#[allow(dead_code)]
pub fn delete_project(path: &str, project: &Project) -> Result<()> {
    let conn = Connection::open(&path)?;
    // Delete all version hashes
    conn.execute("DELETE FROM hash WHERE id IN (SELECT hash FROM version WHERE project_id = (SELECT id FROM project WHERE name = ?))", params![project.name])?;

    // Delete all versions
    conn.execute(
        "DELETE FROM version WHERE project_id = (SELECT id FROM project WHERE name = ?)",
        params![project.name],
    )?;

    // Delete previous logs and next logs
    conn.execute("DELETE FROM hash WHERE id = (SELECT prev_hash FROM changelog WHERE project_id = (SELECT id FROM project WHERE name = ?))", params![project.name])?;
    conn.execute("DELETE FROM hash WHERE id = (SELECT hash FROM changelog WHERE project_id = (SELECT id FROM project WHERE name = ?))", params![project.name])?;

    // Delete changelog associated with project
    conn.execute(
        "DELETE FROM changelog where project_id = (SELECT id FROM project WHERE name = ?)",
        params![project.name],
    )?;

    // Delete associated branch with project
    conn.execute(
        "DELETE FROM branch WHERE project_id = (SELECT id FROM project WHERE name = ?)",
        params![project.name],
    )?;

    // Delete associated tags with project
    conn.execute(
        "DELETE FROM tag WHERE project_id = (SELECT id FROM project WHERE name = ?)",
        params![project.name],
    )?;

    // Delete project entry
    conn.execute("DELETE FROM project WHERE name = ?", params![project.name])?;
    Ok(())
}
