use crate::core::models::{Changelog, Project, Version};
use anyhow::Result;
use rusqlite::{params, Connection};

#[allow(dead_code)]
pub fn create_project(path: &str, proj: &Project) -> Result<()> {
    let conn = Connection::open(path)?;
    // Add new project
    conn.execute("INSERT OR IGNORE INTO project (name, description, url, emoji, is_featured, is_template) VALUES (?1, ?2, ?3, ?4, ?5, ?6)", params![proj.name, proj.desc, proj.url, proj.emoji, proj.featured as u8, proj.template as u8])?;

    // Add new tag
    for t in proj.tags.iter() {
        conn.execute(
            "INSERT OR IGNORE INTO tag (name, project_id) VALUES (?1, (SELECT id FROM project WHERE name = ?2))",
            params![t, proj.name],
        )?;
    }

    // Add new branch
    conn.execute(
        "INSERT OR IGNORE INTO branch (name, project_id) VALUES (?1, (SELECT id FROM project WHERE name = ?2))",
        params![proj.branch, proj.name],
    )?;

    Ok(())
}

#[allow(dead_code)]
pub fn create_changelog(path: &str, changelog: &Changelog) -> Result<()> {
    let conn = Connection::open(path)?;
    // if let Some(data) = &changelog.data {
    // Add hash data
    conn.execute(
        "INSERT OR IGNORE INTO hash (id, data) VALUES (?1, ?2)",
        params![changelog.hash, changelog.data],
    )?;

    // Add new changelog
    conn.execute(
            "INSERT OR IGNORE INTO changelog (project_id, hash, prev_hash) VALUES ((SELECT id FROM project WHERE name = ?1), ?2, ?3)",
            params![changelog.project_name, changelog.hash, String::new()],
    )?;

    Ok(())
}

#[allow(dead_code)]
pub fn create_version(path: &str, version: &Version) -> Result<()> {
    let conn = Connection::open(path)?;
    // Add hash data
    conn.execute(
        "INSERT OR IGNORE INTO hash (id, data) VALUES (?1, ?2)",
        params![version.hash, version.data],
    )?;

    conn.execute(
        "INSERT OR IGNORE INTO version (project_id, hash, release_date, name, major, minor, patch, codename, start_commit, end_commit) VALUES ((SELECT id FROM project WHERE name = ?1), ?2, ?3, ?4, ?5, ?6, ?7, ?8, ?9, ?10)",
        params![version.project_name, version.hash, version.release_date, version.name, version.major, version.minor, version.patch, version.codename, version.start_commit, version.end_commit]
    )?;
    Ok(())
}
