use serde::{Deserialize, Serialize};

pub trait APIs {}
impl APIs for Telegram {}
impl APIs for Twitter {}

/***************************/
/*-------------------------*/
/*--                     --*/
/*--    Config Models    --*/
/*--                     --*/
/*-------------------------*/
/***************************/

#[derive(Deserialize, Debug)]
pub struct Config {
    pub db_path: String,
    pub telegram: Telegram,
    pub twitter: Twitter,
    pub n3nx: N3NX,
}

#[derive(Deserialize, Debug)]
pub struct N3NX {
    pub fetch_url: String,
}

#[derive(Deserialize, Debug)]
pub struct Telegram {
    pub base_url: String,
    pub secret: String,
    pub chat_id: String,
}

#[derive(Deserialize, Debug)]
pub struct Twitter {
    pub base_url: String,
    pub api_key: String,
    pub api_secret: String,
    pub bearer_token: String,
    pub access_token: String,
    pub token_secret: String,
}

/***************************/
/*-------------------------*/
/*--                     --*/
/*--     N3N Models      --*/
/*--                     --*/
/*-------------------------*/
/***************************/

#[derive(Deserialize, Debug, Default)]
pub struct AllProjects {
    pub projects: Vec<Project>,
}

#[derive(Deserialize, Debug, Default, PartialEq)]
pub struct Project {
    pub name: String,
    pub desc: String,
    pub url: String,
    pub tags: Vec<String>,
    pub featured: bool,
    pub emoji: String,
    pub template: bool,
    pub branch: String,
}

#[derive(Debug)]
pub struct Changelog {
    pub project_name: String,
    pub hash: String,
    pub data: String,
}

#[derive(Debug)]
pub struct Version {
    pub project_name: String,
    pub hash: String,
    pub data: String,
    pub release_date: String,
    pub name: String,
    pub major: u8,
    pub minor: u8,
    pub patch: u8,
    pub codename: String,
    pub start_commit: String,
    pub end_commit: String,
}

/***************************/
/*-------------------------*/
/*--                     --*/
/*--   Telegram Models   --*/
/*--                     --*/
/*-------------------------*/
/***************************/

#[derive(Debug, Deserialize, Serialize, Default)]
pub struct TelegramMessageResult {
    ok: bool,
    result: TelegramMessageResp,
}

#[derive(Debug, Deserialize, Serialize, Default)]
struct TelegramMessageResp {
    message_id: u64,
    author_signature: String,
    sender_chat: TelegramChat,
    chat: TelegramChat,
    date: u64,
    text: String,
}

#[derive(Debug, Deserialize, Serialize, Default)]
struct TelegramChat {
    id: i64,
    title: String,
    username: String,
    r#type: String,
}

// #[derive(Debug, Deserialize, Serialize)]
// pub struct Message {
//     pub message_id: u32,
//     pub from: From,
//     pub chat: Chat,
//     pub date: u32,
//     pub text: String,
// }

// #[derive(Debug, Deserialize, Serialize)]
// pub struct From {
//     pub id: u32,
//     pub is_bot: bool,
//     pub first_name: String,
//     pub last_name: String,
//     pub username: String,
//     pub language_code: String,
// }

// #[derive(Debug, Deserialize, Serialize)]
// pub struct Chat {
//     pub id: u32,
//     pub title: String,
//     pub username: String,
//     pub r#type: String,
// }

// #[derive(Debug, Deserialize)]
// pub struct AllUpdates {
//     pub ok: bool,
//     pub result: Vec<Updates>,
// }

// #[derive(Debug, Deserialize)]
// pub struct Updates {
//     pub update_id: u32,
//     pub message: Message,
// }

/***************************/
/*-------------------------*/
/*--                     --*/
/*--   Twitter Models    --*/
/*--                     --*/
/*-------------------------*/
/***************************/

#[derive(Debug, Serialize)]
pub struct TwitterPostReq {
    pub text: String,
}

#[derive(Deserialize)]
pub struct TwitterResp {
    pub data: TwitterRespData,
}

#[derive(Deserialize)]
pub struct TwitterRespData {
    pub id: u64,
    pub text: String,
}

/***************************/
/*-------------------------*/
/*--                     --*/
/*--   Discord Models    --*/
/*--                     --*/
/*-------------------------*/
/***************************/

/***************************/
/*-------------------------*/
/*--                     --*/
/*--    Reddit Models    --*/
/*--                     --*/
/*-------------------------*/
/***************************/

/***************************/
/*-------------------------*/
/*--                     --*/
/*--   LinkedIn Models   --*/
/*--                     --*/
/*-------------------------*/
/***************************/

/***************************/
/*-------------------------*/
/*--                     --*/
/*--    Slack Models     --*/
/*--                     --*/
/*-------------------------*/
/***************************/
