# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.2.1] - 2021-12-10

[0.2.1]: ../../../compare/b80d2ed6948106970ebcdd22a279e6e6f11fe095...a92c923f77dcc84acbf2e4af04ca5d211257acdd

### Improvements

- *core:* Optimize social runner to prioritize in-memory objects first ([6da4be1](6da4be10f085c9a79fc465ce614a64907322cfd2))
- *wolfie:* Improve cli aesthetics for more friendly look ([a92c923](a92c923f77dcc84acbf2e4af04ca5d211257acdd))

<!-- CHANGELOG SPLIT MARKER -->
## [0.2.0] - 2021-12-09

[0.2.0]: ../../../compare/9c087fa14def753c2f93c28486e857aac7b85e8a...b80d2ed6948106970ebcdd22a279e6e6f11fe095

### Bug Fixes

- *db:* Fix query for `get_versions` for respective projects ([540263d](540263d8d01699ac7107d568f270026240191db1))

### Extra Tasks

- *cargo:* Update `sha2` to v0.10.0 ([c921d7e](c921d7eaad21bb69c5e2a4ba05b8109ab8ba6df6))

### Features

- *db:* Add database features for wolfie data integrity ([c387eb6](c387eb65ac33bdad01d3de10d99f315570e5cff3))
- *db:* Add database handling functions and queries for controllers ([25b4892](25b4892750f437787049c779a994eee549543a33))

### Improvements

- *builder:* Improve builder to use database queries and objects for posts ([d1d7d87](d1d7d873603a0bb63b0d94f096aa1592eb6beab5))
- *core:* Upgrade wolfie core for timed data fetch and high performance ([e3bbe1b](e3bbe1b4bbe8effcc20cece189102ca0b3fffb12))

### Refactoring Updates

- *core:* Remove all declarations of twitter apis from runner ([7e41bd4](7e41bd44d7bf7ba4369ee5af05f6dd9024a6f24d))
- *core:* Change fetch_time `PERIOD` from 1 minute to 30 minutes ([725d209](725d20972f400dc650bcb1126e0557cd88a6d7bc))

<!-- CHANGELOG SPLIT MARKER -->
## [0.1.0] - 2021-12-01

[0.1.0]: ../../../releases/tag/v0.1.0

### Bug Fixes

- *log:* Remove template projects from apis queue with empty body fix ([a4787e1](a4787e1ed70b9c18816fc55c90abba3a29a6c64f))

### Documentation

- *wolfie:* Update project tags in `readme.md` file and `Cargo.toml` ([bdc4af7](bdc4af7d2e13ca9305620725a675fecd2c96613e))

### Features

- *api:* Add twitter api client and add generics `SocialBox` ([cd4740d](cd4740d413cc61bbe2402b88f9da8b1f90d03d21))

### Improvements

- *api:* Optimize api models for streamlining apps ([03bcb46](03bcb4682bc1b37bceaa4ba9148d46de5309a0fe))
- *builder:* Add tweet and telegram message builder with few refactors ([26a372c](26a372c43b2d06ce159ea8b38b56764bd73c9c4f))
- *parser:* Add project emoji in telegram message headers ([ff0ce81](ff0ce814a9e51640ecfb4b4806abf161367d9176))

### Styling

- *wolfie:* Prettify api, log and models file ([fd695f3](fd695f37d8849d33fe0e29a14d4154945104ef45))

<!-- CHANGELOG SPLIT MARKER -->
