mod api;
mod builder;
mod log;
mod models;

use crate::api::*;
use crate::builder::Builder;
use crate::log::*;
use crate::models::Config;

use clap::{App, Arg};
use std::fs::read_to_string;

fn main() -> Result<(), Box<dyn std::error::Error>> {
    let matches = App::new("N3NX Wolfie Logistics Service")
        .version("0.1")
        .author("Naman Bishnoi <nmn@n3n.org>")
        .about("Delivers latest N3NX projects news all around the world.")
        .arg(
            Arg::with_name("config")
                .help("Sets a config file to use")
                .required(true)
                .index(1),
        )
        .get_matches();

    let config = matches.value_of("config").unwrap_or("default.conf");
    let raw_config = read_to_string(config)?;
    let config: Config = toml::from_str(&raw_config).unwrap();
    // println!("{:?}", config);

    let all_projects = N3NBox::fetch_all().unwrap();
    let changelog_split_marker = "<!-- CHANGELOG SPLIT MARKER -->";
    let changelog_head = "# Changelog\n\nAll notable changes to this project will be documented in this file.\n\nThe format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),\nand this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).\n\n";

    let tele_client = TelegramBox::new(reqwest::Client::new(), &config.telegram);
    let twitter_client = TwitterBox::new(reqwest::Client::new(), &config.twitter);
    for n3n in all_projects.iter()
    // .filter(|p| p.project.name == "opencl-rs")
    {
        let changelog = n3n.get().unwrap();
        if let Some(log_data) = changelog.data {
            let changelog_data = log_data
                .trim_start_matches(changelog_head)
                .split(changelog_split_marker)
                .map(|x| x.trim())
                .collect::<Vec<&str>>();
            changelog_data
                .iter()
                .filter(|x| !x.is_empty())
                .for_each(|x| {
                    let output_tele = tele_client
                        .send(TelegramBox::build(changelog.project, x))
                        .unwrap();

                    // let output_twitter = twitter_client
                    //     .send(TwitterBox::build(changelog.project, x))
                    //     .unwrap();
                    println!("{:?}", output_tele);
                    // println!("{}", TwitterBox::build(changelog.project, x))
                });
        }
    }
    Ok(())
}
