<!-- Include a quick summary of the changes made in this PR. -->

# Change Type 

See [Semantic Versioning](https://semver.org/) for more information.

<!-- Select one (Delete the rest): -->

- Non-Code
- Patch
- Minor
- Major

<!--
Guidelines: 

- Non-Code: Changes are not to the code base.
- Patch: Changes do not effect the public API.
- Minor: Any changes to the public API before version 1.0, or backwards-compatible changes to the public API after version 1.0.
- Major: Any non-backwards-compatible change to the public API after version 1.0.  
 
Be aware that we will be unwilling to accept Major changes without careful consideration and a **VERY** good reason.
-->

# Changes Made

<!-- Planned changes should be done as a checklist, and changes marked off when completed. -->

- [ ] Add Change 1
  - [ ] Part 1
  - [ ] Part 2
- [ ] Add Change 2
- [ ] Add Change 3

# Merge Checklist

This is the standard checklist of tasks that **MUST** be completed before a PR can be accepted.

- [ ] Feature Completeness
  - [ ] All planned changes have been completed.
  - [ ] New behaviors are covered by tests.
- [ ] Code Quality
  - [ ] The codebase has been cleaned up and refactored.
  - [ ] The codebase is formatted correctly (run `cargo fmt`.)
  - [ ] All compiler warnings have been resolved.
  - [ ] All Clippy warnings have been resolved (run `cargo clippy`.)
- [ ] Documentation
  - [ ] The documentation has been updated.
  - [ ] Relavent examples have been provided in `/examples`.
  - [ ] All doctests / examples are passing.
  - [ ] All documentation warnings / errors have been resolved.
- [ ] Merge
  - [ ] The feature branch has been brought up to date with the main branch.
  - [ ] The version number has been bumped.
  - [ ] I understand and agree to the contribution guidelines.
