#[cfg(test)]
mod tests {
    #[test]
    fn package() {
        let package : [u8; 102] = [0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6, 0x2C, 0xF0, 0x2D, 0x09, 0xB7, 0xB6];
        let generated = wole::generate_magic_package("2CF02D09B7B6").unwrap();
        assert!(package.iter().zip(generated.iter()).all(|(a,b)| a == b), "Package response is not true");
    }

    #[test]
    fn package_len() {
        let generated = wole::generate_magic_package("2CF02D09B7B6").unwrap();
        assert_eq!(generated.len(), 102, "Generated package length does not fit to WOL requirements");
    }
}