use std::fs::File;
use std::io::BufReader;
use std::path::Path;

pub fn read_file_to_str(filename: &str) -> anyhow::Result<String> {
    let path = Path::new(filename);
    let file = File::open(&path).unwrap();
    let reader = BufReader::new(file);

    Ok(String::from_iter(
        reader.buffer().into_iter().map(|byte| *byte as char),
    ))
}
