pub mod camera;
pub mod instance;
pub mod model;
pub mod pipeline;
pub mod renderer;
pub mod texture;
pub use camera::*;
pub use instance::*;
pub use model::*;
pub use pipeline::*;
pub use renderer::*;
pub use texture::*;

/// A type which gives access to a certain window.
/// # Fields
/// - `window` : a handle to the actual window
/// - `event_loop` : a proxy to the event loop. This needs to be a proxy because
/// winit::event_loop_proxy cannot be shared between threads. Used to wake up the
/// actual event loop from another thread.
pub struct Window {
    pub window: winit::window::Window,
    pub event_loop: winit::event_loop::EventLoopProxy<()>,
}
