//! A collection of constants defining basic shapes.

use lazy_static::lazy_static;

pub struct Shape {
    pub vertex_buffer: &'static [u8],
    pub index_buffer: &'static [u8],
}

#[rustfmt::skip]
lazy_static! {
    pub static ref SQUARE: Shape = Shape {
        vertex_buffer: bytemuck::cast_slice(&[
            -0.1, 0.1, 0.0,
            -0.1, -0.1, 0.0,
            0.1, -0.1, 0.0,
            0.1, 0.1, 0.0
        ]),
        index_buffer: bytemuck::cast_slice(&[
            1u32, 2u32, 3u32,
            3u32, 4u32, 1u32
        ])
    };
}

#[rustfmt::skip]
lazy_static! {
    pub static ref ISOSCELES_TRIANGLE: Shape = Shape {
        vertex_buffer: bytemuck::cast_slice(&[
            0.0, 0.1, 0.0,
            -0.1, 0.0, 0.0,
            0.1, 0.0, 0.0
        ]),
        index_buffer: bytemuck::cast_slice(&[
            1u32, 2u32, 3u32
        ])
    };
}
