pub mod shapes;
pub mod types;
use anyhow::Context;
pub use types::*;

mod util;

use winit::{event_loop::EventLoop, window::WindowBuilder};

#[macro_use]
extern crate log;

/// Initializes everything the renderer needs.
pub fn init() -> anyhow::Result<()> {
    pretty_env_logger::init();
    info!("Initiating Witchcraft renderer...");
    Ok(())
}

/// Creates a window with the given dimensions at the given position.
/// Returns the resulting Window.
/// # Panics
/// `get_window` will panic when called outside the main thread.
pub fn get_window(size: (u32, u32), pos: (u32, u32)) -> anyhow::Result<Window> {
    let event_loop = EventLoop::new();
    let window = WindowBuilder::new()
        .build(&event_loop)
        .context("Failed to build window.")
        .unwrap();

    use winit::dpi::{PhysicalPosition, PhysicalSize};
    // the user is more likely to specify the size that they want to use
    // instead of the size that they want the window to occupy
    // so I've decided to use set_inner_size
    window.set_inner_size(PhysicalSize::new(size.0, size.1));
    window.set_outer_position(PhysicalPosition::new(pos.0, pos.1));

    Ok(Window {
        window,
        event_loop: event_loop.create_proxy(),
    })
}
