struct Application {
    check: bool,
}

impl Application {
    fn new() -> anyhow::Result<Self> {
        let window = wita::WindowBuilder::new().build()?;
        std::thread::spawn(move || {
            std::thread::sleep(std::time::Duration::from_millis(500));
            window.minimize();
            std::thread::sleep(std::time::Duration::from_millis(500));
            assert!(window.is_minimized());
            window.close();
        });
        Ok(Self { check: false })
    }
}

impl wita::EventHandler for Application {
    fn minimized(&mut self, _ev: wita::event::Minimized) {
        self.check = true;
    }

    fn closed(&mut self, _ev: wita::event::Closed) {
        assert!(self.check);
    }
}

#[test]
pub fn minimize() {
    wita::run(wita::RunType::Wait, Application::new).unwrap();
}
