struct Application;

impl Application {
    fn new() -> anyhow::Result<Self> {
        wita::Window::builder()
            .title("wita window params")
            .position((100, 100))
            .build()?;
        Ok(Self)
    }
}

impl wita::EventHandler for Application {
    fn resizing(&mut self, ev: wita::event::Resizing) {
        println!("resizing: {:?}: {:?}", ev.edge, ev.size);
    }

    fn resized(&mut self, ev: wita::event::Resized) {
        println!("resized: {:?}", ev.size);
    }

    fn minimized(&mut self, _ev: wita::event::Minimized) {
        println!("minimized");
    }

    fn maximized(&mut self, ev: wita::event::Maximized) {
        println!("maximized: {:?}", ev.size);
    }

    fn restored(&mut self, ev: wita::event::Restored) {
        println!("restored: {:?}", ev.size);
    }

    fn moved(&mut self, ev: wita::event::Moved) {
        println!("moved: {:?}", ev.position);
    }

    fn key_input(&mut self, ev: wita::event::KeyInput) {
        if ev.state == wita::KeyState::Pressed {
            match ev.key_code.vkey {
                wita::VirtualKey::Char('M') => {
                    ev.window.set_position(wita::ScreenPosition::new(100, 100))
                }
                wita::VirtualKey::Char('R') => {
                    ev.window.set_position(wita::ScreenPosition::new(0, 0))
                }
                wita::VirtualKey::Char('S') => {
                    ev.window.set_inner_size(wita::LogicalSize::new(256, 256))
                }
                _ => (),
            }
        }
    }

    fn dpi_changed(&mut self, ev: wita::event::DpiChanged) {
        println!(
            "dpi changed: {} (scale_factor: {})",
            ev.new_dpi,
            ev.window.scale_factor()
        );
    }
}

fn main() {
    wita::run(wita::RunType::Wait, Application::new).unwrap();
}
