struct Application {
    accept_drag_files: bool,
}

impl Application {
    fn new() -> anyhow::Result<Self> {
        wita::Window::builder()
            .title("wita drop files")
            .accept_drag_files(true)
            .build()?;
        Ok(Self {
            accept_drag_files: true,
        })
    }
}

impl wita::EventHandler for Application {
    fn drop_files(&mut self, ev: wita::event::DropFiles) {
        println!("drop files: {:?}, {:?}", ev.paths, ev.position);
    }

    fn key_input(&mut self, ev: wita::event::KeyInput) {
        if ev.state == wita::KeyState::Pressed && ev.key_code.vkey == wita::VirtualKey::Char('T') {
            self.accept_drag_files = !self.accept_drag_files;
            ev.window.accept_drag_files(self.accept_drag_files);
            if self.accept_drag_files {
                println!("enabled accept_drag_files");
            } else {
                println!("disabled accept_drag_files");
            }
        }
    }
}

fn main() {
    wita::run(wita::RunType::Wait, Application::new).unwrap();
}
