struct Application {
    check: bool,
}

impl Application {
    fn new() -> anyhow::Result<Self> {
        let window = wita::WindowBuilder::new().build()?;
        std::thread::spawn(move || {
            std::thread::sleep(std::time::Duration::from_millis(500));
            window.maximize();
            std::thread::sleep(std::time::Duration::from_millis(500));
            assert!(window.is_maximized());
            window.close();
        });
        Ok(Self { check: false })
    }
}

impl wita::EventHandler for Application {
    fn maximized(&mut self, _ev: wita::event::Maximized) {
        self.check = true;
    }

    fn closed(&mut self, _ev: wita::event::Closed) {
        assert!(self.check);
    }
}

#[test]
pub fn maximize() {
    wita::run(wita::RunType::Wait, Application::new).unwrap();
}
