struct Application {
    frame: bool,
}

impl Application {
    fn new() -> anyhow::Result<Self> {
        wita::Window::builder()
            .title("wita no redirection bitmap")
            .no_redirection_bitmap(true)
            .build()?;
        Ok(Self { frame: true })
    }
}

impl wita::EventHandler for Application {
    fn key_input(&mut self, ev: wita::event::KeyInput) {
        if ev.state == wita::KeyState::Pressed {
            match ev.key_code.vkey {
                wita::VirtualKey::Char('Q') => ev.window.close(),
                wita::VirtualKey::Char('T') => {
                    if !self.frame {
                        ev.window.set_style(wita::WindowStyle::dialog());
                    } else {
                        ev.window.set_style(wita::WindowStyle::borderless());
                    }
                    println!("{:?}", ev.window.position());
                    self.frame = !self.frame;
                }
                _ => (),
            }
        }
    }
}

fn main() {
    wita::run(wita::RunType::Wait, Application::new).unwrap();
}
