struct Application;

impl Application {
    const MAX_SIZE: wita::PhysicalSize<u32> = wita::PhysicalSize::new(1024, 1024);

    fn new() -> anyhow::Result<Self> {
        wita::Window::builder()
            .title("wita max size")
            .inner_size(wita::PhysicalSize::new(512, 512))
            .build()?;
        Ok(Self)
    }
}

impl wita::EventHandler for Application {
    fn resizing(&mut self, ev: wita::event::Resizing) {
        if ev.size.width > Self::MAX_SIZE.width {
            ev.size.width = Self::MAX_SIZE.width;
        }
        if ev.size.height > Self::MAX_SIZE.height {
            ev.size.height = Self::MAX_SIZE.height;
        }
    }
}

fn main() {
    wita::run(wita::RunType::Wait, Application::new).unwrap();
}
