struct Application;

impl Application {
    fn new() -> anyhow::Result<Self> {
        let window = wita::Window::builder()
            .title("wita ime")
            .ime(true)
            .visible_ime_composition_window(true)
            .visible_ime_candidate_window(false)
            .build()?;
        window.set_ime_position(wita::LogicalPosition::new(100, 100));
        Ok(Self)
    }
}

impl wita::EventHandler for Application {
    fn key_input(&mut self, ev: wita::event::KeyInput) {
        if ev.key_code.vkey == wita::VirtualKey::F(1) && ev.state == wita::KeyState::Released {
            let flag = !ev.window.is_enabled_ime();
            ev.window.ime(flag);
            if flag {
                println!("enabled ime");
            } else {
                println!("disabled ime");
            }
        }
    }

    fn ime_start_composition(&mut self, _: wita::event::ImeStartComposition) {
        println!("ime start composition");
    }

    fn ime_composition(&mut self, ev: wita::event::ImeComposition) {
        println!(
            "ime composition: {:?} {:?}",
            ev.composition, ev.candidate_list
        );
    }

    fn ime_end_composition(&mut self, ev: wita::event::ImeEndComposition) {
        println!("ime end composition: {:?}", ev.result);
    }
}

fn main() {
    wita::run(wita::RunType::Wait, Application::new).unwrap();
}
