struct Application;

impl Application {
    fn new() -> anyhow::Result<Self> {
        wita::Window::builder()
            .style(wita::WindowStyle::borderless())
            .build()?;
        Ok(Self)
    }
}

impl wita::EventHandler for Application {
    fn key_input(&mut self, ev: wita::event::KeyInput) {
        if ev.state == wita::KeyState::Pressed {
            match ev.key_code.vkey {
                wita::VirtualKey::Char('Q') => ev.window.close(),
                wita::VirtualKey::Char('T') => {
                    if ev.window.style().is_borderless() {
                        ev.window.set_style(wita::WindowStyle::default());
                    } else {
                        ev.window.set_style(wita::WindowStyle::borderless());
                    }
                }
                _ => (),
            }
        }
    }
}

fn main() {
    wita::run(wita::RunType::Wait, Application::new).unwrap();
}
