struct Application;

impl Application {
    fn new() -> anyhow::Result<Self> {
        wita::Window::builder().title("wita events").build()?;
        Ok(Self)
    }
}

impl wita::EventHandler for Application {
    fn draw(&mut self, _: wita::event::Draw) {
        println!("draw");
    }

    fn activated(&mut self, _: wita::event::Activated) {
        println!("activated");
    }

    fn inactivated(&mut self, _: wita::event::Inactivated) {
        println!("inactivated");
    }

    fn closed(&mut self, _: wita::event::Closed) {
        println!("closed");
    }

    fn resizing(&mut self, ev: wita::event::Resizing) {
        println!("resizing: {:?}", ev.size);
    }

    fn resized(&mut self, ev: wita::event::Resized) {
        println!("resized: {:?}", ev.size);
    }

    fn moved(&mut self, ev: wita::event::Moved) {
        println!("moved: {:?}", ev.position);
    }

    fn dpi_changed(&mut self, ev: wita::event::DpiChanged) {
        println!(
            "dpi changed: {} (scale_factor: {})",
            ev.new_dpi,
            ev.window.scale_factor()
        );
    }

    fn mouse_input(&mut self, ev: wita::event::MouseInput) {
        println!(
            "mouse_input: {:?}, {:?}, {:?}",
            ev.button, ev.button_state, ev.mouse_state
        );
    }

    fn cursor_moved(&mut self, ev: wita::event::CursorMoved) {
        println!(
            "cursor moved: {:?} {:?}",
            ev.mouse_state,
            ev.mouse_state.position.to_logical(ev.window.dpi() as i32)
        );
    }

    fn cursor_entered(&mut self, ev: wita::event::CursorEntered) {
        println!("cursor entered: {:?}", ev.mouse_state);
    }

    fn cursor_leaved(&mut self, ev: wita::event::CursorLeaved) {
        println!("cursor leaved: {:?}", ev.mouse_state);
    }

    fn mouse_wheel(&mut self, ev: wita::event::MouseWheel) {
        println!(
            "mouse wheel: {:?}, {}, {:?}",
            ev.axis, ev.distance, ev.mouse_state
        );
    }

    fn key_input(&mut self, ev: wita::event::KeyInput) {
        println!(
            "key input: {:?}, {:?}, {}",
            ev.key_code, ev.state, ev.prev_pressed
        );
    }

    fn char_input(&mut self, ev: wita::event::CharInput) {
        if ev.c.is_control() || ev.c.is_whitespace() {
            println!("char input: 0x{:02x}", ev.c as u16);
        } else {
            println!("char input: {}", ev.c);
        }
    }

    fn ime_start_composition(&mut self, _: wita::event::ImeStartComposition) {
        println!("ime start composition");
    }

    fn ime_composition(&mut self, ev: wita::event::ImeComposition) {
        println!(
            "ime composition: {:?} {:?}",
            ev.composition, ev.candidate_list
        );
    }

    fn ime_end_composition(&mut self, ev: wita::event::ImeEndComposition) {
        println!("ime end composition: {:?}", ev.result);
    }

    fn other(&mut self, params: wita::event::Other) -> Option<isize> {
        println!("other: {:?}", params);
        None
    }
}

fn main() {
    wita::run(wita::RunType::Wait, Application::new).unwrap();
}
