/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type wchar_t = ::std::os::raw::c_ushort;
pub type ULONG = ::std::os::raw::c_ulong;
pub type USHORT = ::std::os::raw::c_ushort;
pub type UCHAR = ::std::os::raw::c_uchar;
pub type DWORD = ::std::os::raw::c_ulong;
pub type BOOL = ::std::os::raw::c_int;
pub type BYTE = ::std::os::raw::c_uchar;
pub type WORD = ::std::os::raw::c_ushort;
pub type ULONG64 = ::std::os::raw::c_ulonglong;
pub type DWORD64 = ::std::os::raw::c_ulonglong;
pub type CHAR = ::std::os::raw::c_char;
pub type WCHAR = wchar_t;
pub type LPCWSTR = *const WCHAR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GUID {
    pub Data1: ::std::os::raw::c_ulong,
    pub Data2: ::std::os::raw::c_ushort,
    pub Data3: ::std::os::raw::c_ushort,
    pub Data4: [::std::os::raw::c_uchar; 8usize],
}
#[test]
fn bindgen_test_layout__GUID() {
    assert_eq!(
        ::std::mem::size_of::<_GUID>(),
        16usize,
        concat!("Size of: ", stringify!(_GUID))
    );
    assert_eq!(
        ::std::mem::align_of::<_GUID>(),
        4usize,
        concat!("Alignment of ", stringify!(_GUID))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GUID>())).Data1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GUID),
            "::",
            stringify!(Data1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GUID>())).Data2 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_GUID),
            "::",
            stringify!(Data2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GUID>())).Data3 as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_GUID),
            "::",
            stringify!(Data3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GUID>())).Data4 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GUID),
            "::",
            stringify!(Data4)
        )
    );
}
pub type GUID = _GUID;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in_addr {
    pub S_un: in_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in_addr__bindgen_ty_1 {
    pub S_un_b: in_addr__bindgen_ty_1__bindgen_ty_1,
    pub S_un_w: in_addr__bindgen_ty_1__bindgen_ty_2,
    pub S_addr: ULONG,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr__bindgen_ty_1__bindgen_ty_1 {
    pub s_b1: UCHAR,
    pub s_b2: UCHAR,
    pub s_b3: UCHAR,
    pub s_b4: UCHAR,
}
#[test]
fn bindgen_test_layout_in_addr__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<in_addr__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(in_addr__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<in_addr__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(in_addr__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_addr__bindgen_ty_1__bindgen_ty_1>())).s_b1 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(s_b1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_addr__bindgen_ty_1__bindgen_ty_1>())).s_b2 as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(s_b2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_addr__bindgen_ty_1__bindgen_ty_1>())).s_b3 as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(s_b3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_addr__bindgen_ty_1__bindgen_ty_1>())).s_b4 as *const _
                as usize
        },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(s_b4)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr__bindgen_ty_1__bindgen_ty_2 {
    pub s_w1: USHORT,
    pub s_w2: USHORT,
}
#[test]
fn bindgen_test_layout_in_addr__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<in_addr__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(in_addr__bindgen_ty_1__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<in_addr__bindgen_ty_1__bindgen_ty_2>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(in_addr__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_addr__bindgen_ty_1__bindgen_ty_2>())).s_w1 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(s_w1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<in_addr__bindgen_ty_1__bindgen_ty_2>())).s_w2 as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(s_w2)
        )
    );
}
#[test]
fn bindgen_test_layout_in_addr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<in_addr__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(in_addr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<in_addr__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(in_addr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<in_addr__bindgen_ty_1>())).S_un_b as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr__bindgen_ty_1),
            "::",
            stringify!(S_un_b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<in_addr__bindgen_ty_1>())).S_un_w as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr__bindgen_ty_1),
            "::",
            stringify!(S_un_w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<in_addr__bindgen_ty_1>())).S_addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr__bindgen_ty_1),
            "::",
            stringify!(S_addr)
        )
    );
}
#[test]
fn bindgen_test_layout_in_addr() {
    assert_eq!(
        ::std::mem::size_of::<in_addr>(),
        4usize,
        concat!("Size of: ", stringify!(in_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<in_addr>(),
        4usize,
        concat!("Alignment of ", stringify!(in_addr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<in_addr>())).S_un as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_addr),
            "::",
            stringify!(S_un)
        )
    );
}
pub type IN_ADDR = in_addr;
pub type ADDRESS_FAMILY = USHORT;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SCOPE_ID {
    pub __bindgen_anon_1: SCOPE_ID__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SCOPE_ID__bindgen_ty_1 {
    pub __bindgen_anon_1: SCOPE_ID__bindgen_ty_1__bindgen_ty_1,
    pub Value: ULONG,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct SCOPE_ID__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_SCOPE_ID__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<SCOPE_ID__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(SCOPE_ID__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SCOPE_ID__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(SCOPE_ID__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl SCOPE_ID__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn Zone(&self) -> ULONG {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set_Zone(&mut self, val: ULONG) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn Level(&self) -> ULONG {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_Level(&mut self, val: ULONG) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(Zone: ULONG, Level: ULONG) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 28u8, {
            let Zone: u32 = unsafe { ::std::mem::transmute(Zone) };
            Zone as u64
        });
        __bindgen_bitfield_unit.set(28usize, 4u8, {
            let Level: u32 = unsafe { ::std::mem::transmute(Level) };
            Level as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_SCOPE_ID__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<SCOPE_ID__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(SCOPE_ID__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<SCOPE_ID__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(SCOPE_ID__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SCOPE_ID__bindgen_ty_1>())).Value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SCOPE_ID__bindgen_ty_1),
            "::",
            stringify!(Value)
        )
    );
}
#[test]
fn bindgen_test_layout_SCOPE_ID() {
    assert_eq!(
        ::std::mem::size_of::<SCOPE_ID>(),
        4usize,
        concat!("Size of: ", stringify!(SCOPE_ID))
    );
    assert_eq!(
        ::std::mem::align_of::<SCOPE_ID>(),
        4usize,
        concat!("Alignment of ", stringify!(SCOPE_ID))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in {
    pub sin_family: ADDRESS_FAMILY,
    pub sin_port: USHORT,
    pub sin_addr: IN_ADDR,
    pub sin_zero: [CHAR; 8usize],
}
#[test]
fn bindgen_test_layout_sockaddr_in() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr_in>(),
        16usize,
        concat!("Size of: ", stringify!(sockaddr_in))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_in>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_in))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in>())).sin_family as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in>())).sin_port as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in>())).sin_addr as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in>())).sin_zero as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_zero)
        )
    );
}
pub type SOCKADDR_IN = sockaddr_in;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub u: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub Byte: [UCHAR; 16usize],
    pub Word: [USHORT; 8usize],
}
#[test]
fn bindgen_test_layout_in6_addr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<in6_addr__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(in6_addr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<in6_addr__bindgen_ty_1>(),
        2usize,
        concat!("Alignment of ", stringify!(in6_addr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<in6_addr__bindgen_ty_1>())).Byte as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr__bindgen_ty_1),
            "::",
            stringify!(Byte)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<in6_addr__bindgen_ty_1>())).Word as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr__bindgen_ty_1),
            "::",
            stringify!(Word)
        )
    );
}
#[test]
fn bindgen_test_layout_in6_addr() {
    assert_eq!(
        ::std::mem::size_of::<in6_addr>(),
        16usize,
        concat!("Size of: ", stringify!(in6_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<in6_addr>(),
        2usize,
        concat!("Alignment of ", stringify!(in6_addr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<in6_addr>())).u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr),
            "::",
            stringify!(u)
        )
    );
}
pub type IN6_ADDR = in6_addr;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _NET_LUID_LH {
    pub Value: ULONG64,
    pub Info: _NET_LUID_LH__bindgen_ty_1,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct _NET_LUID_LH__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout__NET_LUID_LH__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_NET_LUID_LH__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_NET_LUID_LH__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_NET_LUID_LH__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_NET_LUID_LH__bindgen_ty_1))
    );
}
impl _NET_LUID_LH__bindgen_ty_1 {
    #[inline]
    pub fn Reserved(&self) -> ULONG64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u64) }
    }
    #[inline]
    pub fn set_Reserved(&mut self, val: ULONG64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn NetLuidIndex(&self) -> ULONG64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 24u8) as u64) }
    }
    #[inline]
    pub fn set_NetLuidIndex(&mut self, val: ULONG64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn IfType(&self) -> ULONG64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(48usize, 16u8) as u64) }
    }
    #[inline]
    pub fn set_IfType(&mut self, val: ULONG64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(48usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        Reserved: ULONG64,
        NetLuidIndex: ULONG64,
        IfType: ULONG64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let Reserved: u64 = unsafe { ::std::mem::transmute(Reserved) };
            Reserved as u64
        });
        __bindgen_bitfield_unit.set(24usize, 24u8, {
            let NetLuidIndex: u64 = unsafe { ::std::mem::transmute(NetLuidIndex) };
            NetLuidIndex as u64
        });
        __bindgen_bitfield_unit.set(48usize, 16u8, {
            let IfType: u64 = unsafe { ::std::mem::transmute(IfType) };
            IfType as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout__NET_LUID_LH() {
    assert_eq!(
        ::std::mem::size_of::<_NET_LUID_LH>(),
        8usize,
        concat!("Size of: ", stringify!(_NET_LUID_LH))
    );
    assert_eq!(
        ::std::mem::align_of::<_NET_LUID_LH>(),
        8usize,
        concat!("Alignment of ", stringify!(_NET_LUID_LH))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_NET_LUID_LH>())).Value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_NET_LUID_LH),
            "::",
            stringify!(Value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_NET_LUID_LH>())).Info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_NET_LUID_LH),
            "::",
            stringify!(Info)
        )
    );
}
pub type NET_LUID_LH = _NET_LUID_LH;
pub type NET_LUID = NET_LUID_LH;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_family: ADDRESS_FAMILY,
    pub sin6_port: USHORT,
    pub sin6_flowinfo: ULONG,
    pub sin6_addr: IN6_ADDR,
    pub __bindgen_anon_1: sockaddr_in6__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sockaddr_in6__bindgen_ty_1 {
    pub sin6_scope_id: ULONG,
    pub sin6_scope_struct: SCOPE_ID,
}
#[test]
fn bindgen_test_layout_sockaddr_in6__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr_in6__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(sockaddr_in6__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_in6__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_in6__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in6__bindgen_ty_1>())).sin6_scope_id as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6__bindgen_ty_1),
            "::",
            stringify!(sin6_scope_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sockaddr_in6__bindgen_ty_1>())).sin6_scope_struct as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6__bindgen_ty_1),
            "::",
            stringify!(sin6_scope_struct)
        )
    );
}
#[test]
fn bindgen_test_layout_sockaddr_in6() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr_in6>(),
        28usize,
        concat!("Size of: ", stringify!(sockaddr_in6))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_in6>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_in6))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in6>())).sin6_family as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in6>())).sin6_port as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_port)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in6>())).sin6_flowinfo as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_flowinfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sockaddr_in6>())).sin6_addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_addr)
        )
    );
}
pub type SOCKADDR_IN6_LH = sockaddr_in6;
pub type SOCKADDR_IN6 = SOCKADDR_IN6_LH;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _SOCKADDR_INET {
    pub Ipv4: SOCKADDR_IN,
    pub Ipv6: SOCKADDR_IN6,
    pub si_family: ADDRESS_FAMILY,
}
#[test]
fn bindgen_test_layout__SOCKADDR_INET() {
    assert_eq!(
        ::std::mem::size_of::<_SOCKADDR_INET>(),
        28usize,
        concat!("Size of: ", stringify!(_SOCKADDR_INET))
    );
    assert_eq!(
        ::std::mem::align_of::<_SOCKADDR_INET>(),
        4usize,
        concat!("Alignment of ", stringify!(_SOCKADDR_INET))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_SOCKADDR_INET>())).Ipv4 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_SOCKADDR_INET),
            "::",
            stringify!(Ipv4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_SOCKADDR_INET>())).Ipv6 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_SOCKADDR_INET),
            "::",
            stringify!(Ipv6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_SOCKADDR_INET>())).si_family as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_SOCKADDR_INET),
            "::",
            stringify!(si_family)
        )
    );
}
pub type SOCKADDR_INET = _SOCKADDR_INET;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _WIREGUARD_ADAPTER {
    _unused: [u8; 0],
}
#[doc = " A handle representing WireGuard adapter"]
pub type WIREGUARD_ADAPTER_HANDLE = *mut _WIREGUARD_ADAPTER;
#[doc = "< Informational"]
pub const WIREGUARD_LOGGER_LEVEL_WIREGUARD_LOG_INFO: WIREGUARD_LOGGER_LEVEL = 0;
#[doc = "< Warning"]
pub const WIREGUARD_LOGGER_LEVEL_WIREGUARD_LOG_WARN: WIREGUARD_LOGGER_LEVEL = 1;
#[doc = "< Error"]
pub const WIREGUARD_LOGGER_LEVEL_WIREGUARD_LOG_ERR: WIREGUARD_LOGGER_LEVEL = 2;
#[doc = " Determines the level of logging, passed to WIREGUARD_LOGGER_CALLBACK."]
pub type WIREGUARD_LOGGER_LEVEL = ::std::os::raw::c_int;
#[doc = " Called by internal logger to report diagnostic messages"]
#[doc = ""]
#[doc = " @param Level         Message level."]
#[doc = ""]
#[doc = " @param Timestamp     Message timestamp in in 100ns intervals since 1601-01-01 UTC."]
#[doc = ""]
#[doc = " @param Message       Message text."]
pub type WIREGUARD_LOGGER_CALLBACK = ::std::option::Option<
    unsafe extern "C" fn(Level: WIREGUARD_LOGGER_LEVEL, Timestamp: DWORD64, Message: LPCWSTR),
>;
#[doc = "< No logs are generated from the driver."]
pub const WIREGUARD_ADAPTER_LOG_STATE_WIREGUARD_ADAPTER_LOG_OFF: WIREGUARD_ADAPTER_LOG_STATE = 0;
#[doc = "< Logs are generated from the driver."]
pub const WIREGUARD_ADAPTER_LOG_STATE_WIREGUARD_ADAPTER_LOG_ON: WIREGUARD_ADAPTER_LOG_STATE = 1;
#[doc = "< Logs are generated from the driver, index-prefixed."]
pub const WIREGUARD_ADAPTER_LOG_STATE_WIREGUARD_ADAPTER_LOG_ON_WITH_PREFIX:
    WIREGUARD_ADAPTER_LOG_STATE = 2;
#[doc = " Whether and how logs from the driver are collected for the callback function."]
pub type WIREGUARD_ADAPTER_LOG_STATE = ::std::os::raw::c_int;
#[doc = "< Down"]
pub const WIREGUARD_ADAPTER_STATE_WIREGUARD_ADAPTER_STATE_DOWN: WIREGUARD_ADAPTER_STATE = 0;
#[doc = "< Up"]
pub const WIREGUARD_ADAPTER_STATE_WIREGUARD_ADAPTER_STATE_UP: WIREGUARD_ADAPTER_STATE = 1;
#[doc = " Determines the state of the adapter."]
pub type WIREGUARD_ADAPTER_STATE = ::std::os::raw::c_int;
pub type WIREGUARD_ALLOWED_IP = _WIREGUARD_ALLOWED_IP;
#[repr(C)]
#[repr(align(8))]
#[derive(Copy, Clone)]
pub struct _WIREGUARD_ALLOWED_IP {
    #[doc = "< IP address"]
    pub Address: _WIREGUARD_ALLOWED_IP__bindgen_ty_1,
    #[doc = "< Address family, either AF_INET or AF_INET6"]
    pub AddressFamily: ADDRESS_FAMILY,
    #[doc = "< CIDR of allowed IPs"]
    pub Cidr: BYTE,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _WIREGUARD_ALLOWED_IP__bindgen_ty_1 {
    pub V4: IN_ADDR,
    pub V6: IN6_ADDR,
}
#[test]
fn bindgen_test_layout__WIREGUARD_ALLOWED_IP__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_WIREGUARD_ALLOWED_IP__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(_WIREGUARD_ALLOWED_IP__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_WIREGUARD_ALLOWED_IP__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_WIREGUARD_ALLOWED_IP__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_WIREGUARD_ALLOWED_IP__bindgen_ty_1>())).V4 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_ALLOWED_IP__bindgen_ty_1),
            "::",
            stringify!(V4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_WIREGUARD_ALLOWED_IP__bindgen_ty_1>())).V6 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_ALLOWED_IP__bindgen_ty_1),
            "::",
            stringify!(V6)
        )
    );
}
#[test]
fn bindgen_test_layout__WIREGUARD_ALLOWED_IP() {
    assert_eq!(
        ::std::mem::size_of::<_WIREGUARD_ALLOWED_IP>(),
        24usize,
        concat!("Size of: ", stringify!(_WIREGUARD_ALLOWED_IP))
    );
    assert_eq!(
        ::std::mem::align_of::<_WIREGUARD_ALLOWED_IP>(),
        8usize,
        concat!("Alignment of ", stringify!(_WIREGUARD_ALLOWED_IP))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_ALLOWED_IP>())).Address as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_ALLOWED_IP),
            "::",
            stringify!(Address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_WIREGUARD_ALLOWED_IP>())).AddressFamily as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_ALLOWED_IP),
            "::",
            stringify!(AddressFamily)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_ALLOWED_IP>())).Cidr as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_ALLOWED_IP),
            "::",
            stringify!(Cidr)
        )
    );
}
#[doc = "< The PublicKey field is set"]
pub const WIREGUARD_PEER_FLAG_WIREGUARD_PEER_HAS_PUBLIC_KEY: WIREGUARD_PEER_FLAG = 1;
#[doc = "< The PresharedKey field is set"]
pub const WIREGUARD_PEER_FLAG_WIREGUARD_PEER_HAS_PRESHARED_KEY: WIREGUARD_PEER_FLAG = 2;
#[doc = "< The PersistentKeepAlive field is set"]
pub const WIREGUARD_PEER_FLAG_WIREGUARD_PEER_HAS_PERSISTENT_KEEPALIVE: WIREGUARD_PEER_FLAG = 4;
#[doc = "< The Endpoint field is set"]
pub const WIREGUARD_PEER_FLAG_WIREGUARD_PEER_HAS_ENDPOINT: WIREGUARD_PEER_FLAG = 8;
#[doc = "< Remove all allowed IPs before adding new ones"]
pub const WIREGUARD_PEER_FLAG_WIREGUARD_PEER_REPLACE_ALLOWED_IPS: WIREGUARD_PEER_FLAG = 32;
#[doc = "< Remove specified peer"]
pub const WIREGUARD_PEER_FLAG_WIREGUARD_PEER_REMOVE: WIREGUARD_PEER_FLAG = 64;
#[doc = "< Do not add a new peer"]
pub const WIREGUARD_PEER_FLAG_WIREGUARD_PEER_UPDATE: WIREGUARD_PEER_FLAG = 128;
pub type WIREGUARD_PEER_FLAG = ::std::os::raw::c_int;
pub type WIREGUARD_PEER = _WIREGUARD_PEER;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _WIREGUARD_PEER {
    #[doc = "< Bitwise combination of flags"]
    pub Flags: WIREGUARD_PEER_FLAG,
    #[doc = "< Reserved; must be zero"]
    pub Reserved: DWORD,
    #[doc = "< Public key, the peer's primary identifier"]
    pub PublicKey: [BYTE; 32usize],
    #[doc = "< Preshared key for additional layer of post-quantum resistance"]
    pub PresharedKey: [BYTE; 32usize],
    #[doc = "< Seconds interval, or 0 to disable"]
    pub PersistentKeepalive: WORD,
    #[doc = "< Endpoint, with IP address and UDP port number"]
    pub Endpoint: SOCKADDR_INET,
    #[doc = "< Number of bytes transmitted"]
    pub TxBytes: DWORD64,
    #[doc = "< Number of bytes received"]
    pub RxBytes: DWORD64,
    #[doc = "< Time of the last handshake, in 100ns intervals since 1601-01-01 UTC"]
    pub LastHandshake: DWORD64,
    #[doc = "< Number of allowed IP structs following this struct"]
    pub AllowedIPsCount: DWORD,
}
#[test]
fn bindgen_test_layout__WIREGUARD_PEER() {
    assert_eq!(
        ::std::mem::size_of::<_WIREGUARD_PEER>(),
        136usize,
        concat!("Size of: ", stringify!(_WIREGUARD_PEER))
    );
    assert_eq!(
        ::std::mem::align_of::<_WIREGUARD_PEER>(),
        8usize,
        concat!("Alignment of ", stringify!(_WIREGUARD_PEER))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_PEER>())).Flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(Flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_PEER>())).Reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(Reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_PEER>())).PublicKey as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(PublicKey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_PEER>())).PresharedKey as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(PresharedKey)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_WIREGUARD_PEER>())).PersistentKeepalive as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(PersistentKeepalive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_PEER>())).Endpoint as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(Endpoint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_PEER>())).TxBytes as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(TxBytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_PEER>())).RxBytes as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(RxBytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_PEER>())).LastHandshake as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(LastHandshake)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_PEER>())).AllowedIPsCount as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_PEER),
            "::",
            stringify!(AllowedIPsCount)
        )
    );
}
#[doc = "< The PublicKey field is set"]
pub const WIREGUARD_INTERFACE_FLAG_WIREGUARD_INTERFACE_HAS_PUBLIC_KEY: WIREGUARD_INTERFACE_FLAG = 1;
#[doc = "< The PrivateKey field is set"]
pub const WIREGUARD_INTERFACE_FLAG_WIREGUARD_INTERFACE_HAS_PRIVATE_KEY: WIREGUARD_INTERFACE_FLAG =
    2;
#[doc = "< The ListenPort field is set"]
pub const WIREGUARD_INTERFACE_FLAG_WIREGUARD_INTERFACE_HAS_LISTEN_PORT: WIREGUARD_INTERFACE_FLAG =
    4;
#[doc = "< Remove all peers before adding new ones"]
pub const WIREGUARD_INTERFACE_FLAG_WIREGUARD_INTERFACE_REPLACE_PEERS: WIREGUARD_INTERFACE_FLAG = 8;
pub type WIREGUARD_INTERFACE_FLAG = ::std::os::raw::c_int;
pub type WIREGUARD_INTERFACE = _WIREGUARD_INTERFACE;
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct _WIREGUARD_INTERFACE {
    #[doc = "< Bitwise combination of flags"]
    pub Flags: WIREGUARD_INTERFACE_FLAG,
    #[doc = "< Port for UDP listen socket, or 0 to choose randomly"]
    pub ListenPort: WORD,
    #[doc = "< Private key of interface"]
    pub PrivateKey: [BYTE; 32usize],
    #[doc = "< Corresponding public key of private key"]
    pub PublicKey: [BYTE; 32usize],
    #[doc = "< Number of peer structs following this struct"]
    pub PeersCount: DWORD,
}
#[test]
fn bindgen_test_layout__WIREGUARD_INTERFACE() {
    assert_eq!(
        ::std::mem::size_of::<_WIREGUARD_INTERFACE>(),
        80usize,
        concat!("Size of: ", stringify!(_WIREGUARD_INTERFACE))
    );
    assert_eq!(
        ::std::mem::align_of::<_WIREGUARD_INTERFACE>(),
        8usize,
        concat!("Alignment of ", stringify!(_WIREGUARD_INTERFACE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_INTERFACE>())).Flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_INTERFACE),
            "::",
            stringify!(Flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_INTERFACE>())).ListenPort as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_INTERFACE),
            "::",
            stringify!(ListenPort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_INTERFACE>())).PrivateKey as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_INTERFACE),
            "::",
            stringify!(PrivateKey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_INTERFACE>())).PublicKey as *const _ as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_INTERFACE),
            "::",
            stringify!(PublicKey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_WIREGUARD_INTERFACE>())).PeersCount as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_WIREGUARD_INTERFACE),
            "::",
            stringify!(PeersCount)
        )
    );
}
extern crate libloading;
pub struct wireguard {
    __library: ::libloading::Library,
    pub WireGuardCreateAdapter: unsafe extern "C" fn(
        arg1: LPCWSTR,
        arg2: LPCWSTR,
        arg3: *const GUID,
    ) -> WIREGUARD_ADAPTER_HANDLE,
    pub WireGuardOpenAdapter: unsafe extern "C" fn(arg1: LPCWSTR) -> WIREGUARD_ADAPTER_HANDLE,
    pub WireGuardCloseAdapter: unsafe extern "C" fn(arg1: WIREGUARD_ADAPTER_HANDLE),
    pub WireGuardGetAdapterLUID:
        unsafe extern "C" fn(arg1: WIREGUARD_ADAPTER_HANDLE, arg2: *mut NET_LUID),
    pub WireGuardGetRunningDriverVersion: unsafe extern "C" fn() -> DWORD,
    pub WireGuardDeleteDriver: unsafe extern "C" fn() -> BOOL,
    pub WireGuardSetLogger: unsafe extern "C" fn(arg1: WIREGUARD_LOGGER_CALLBACK),
    pub WireGuardSetAdapterLogging: unsafe extern "C" fn(
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: WIREGUARD_ADAPTER_LOG_STATE,
    ) -> BOOL,
    pub WireGuardGetAdapterState: unsafe extern "C" fn(
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: *mut WIREGUARD_ADAPTER_STATE,
    ) -> BOOL,
    pub WireGuardSetAdapterState:
        unsafe extern "C" fn(arg1: WIREGUARD_ADAPTER_HANDLE, arg2: WIREGUARD_ADAPTER_STATE) -> BOOL,
    pub WireGuardGetConfiguration: unsafe extern "C" fn(
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: *mut WIREGUARD_INTERFACE,
        arg3: *mut DWORD,
    ) -> BOOL,
    pub WireGuardSetConfiguration: unsafe extern "C" fn(
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: *const WIREGUARD_INTERFACE,
        arg3: DWORD,
    ) -> BOOL,
}
impl wireguard {
    pub unsafe fn new<P>(path: P) -> Result<Self, ::libloading::Error>
    where
        P: AsRef<::std::ffi::OsStr>,
    {
        let library = ::libloading::Library::new(path)?;
        Self::from_library(library)
    }
    pub unsafe fn from_library<L>(library: L) -> Result<Self, ::libloading::Error>
    where
        L: Into<::libloading::Library>,
    {
        let __library = library.into();
        let WireGuardCreateAdapter = __library.get(b"WireGuardCreateAdapter\0").map(|sym| *sym)?;
        let WireGuardOpenAdapter = __library.get(b"WireGuardOpenAdapter\0").map(|sym| *sym)?;
        let WireGuardCloseAdapter = __library.get(b"WireGuardCloseAdapter\0").map(|sym| *sym)?;
        let WireGuardGetAdapterLUID = __library
            .get(b"WireGuardGetAdapterLUID\0")
            .map(|sym| *sym)?;
        let WireGuardGetRunningDriverVersion = __library
            .get(b"WireGuardGetRunningDriverVersion\0")
            .map(|sym| *sym)?;
        let WireGuardDeleteDriver = __library.get(b"WireGuardDeleteDriver\0").map(|sym| *sym)?;
        let WireGuardSetLogger = __library.get(b"WireGuardSetLogger\0").map(|sym| *sym)?;
        let WireGuardSetAdapterLogging = __library
            .get(b"WireGuardSetAdapterLogging\0")
            .map(|sym| *sym)?;
        let WireGuardGetAdapterState = __library
            .get(b"WireGuardGetAdapterState\0")
            .map(|sym| *sym)?;
        let WireGuardSetAdapterState = __library
            .get(b"WireGuardSetAdapterState\0")
            .map(|sym| *sym)?;
        let WireGuardGetConfiguration = __library
            .get(b"WireGuardGetConfiguration\0")
            .map(|sym| *sym)?;
        let WireGuardSetConfiguration = __library
            .get(b"WireGuardSetConfiguration\0")
            .map(|sym| *sym)?;
        Ok(wireguard {
            __library,
            WireGuardCreateAdapter,
            WireGuardOpenAdapter,
            WireGuardCloseAdapter,
            WireGuardGetAdapterLUID,
            WireGuardGetRunningDriverVersion,
            WireGuardDeleteDriver,
            WireGuardSetLogger,
            WireGuardSetAdapterLogging,
            WireGuardGetAdapterState,
            WireGuardSetAdapterState,
            WireGuardGetConfiguration,
            WireGuardSetConfiguration,
        })
    }
    pub unsafe fn WireGuardCreateAdapter(
        &self,
        arg1: LPCWSTR,
        arg2: LPCWSTR,
        arg3: *const GUID,
    ) -> WIREGUARD_ADAPTER_HANDLE {
        (self.WireGuardCreateAdapter)(arg1, arg2, arg3)
    }
    pub unsafe fn WireGuardOpenAdapter(&self, arg1: LPCWSTR) -> WIREGUARD_ADAPTER_HANDLE {
        (self.WireGuardOpenAdapter)(arg1)
    }
    pub unsafe fn WireGuardCloseAdapter(&self, arg1: WIREGUARD_ADAPTER_HANDLE) -> () {
        (self.WireGuardCloseAdapter)(arg1)
    }
    pub unsafe fn WireGuardGetAdapterLUID(
        &self,
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: *mut NET_LUID,
    ) -> () {
        (self.WireGuardGetAdapterLUID)(arg1, arg2)
    }
    pub unsafe fn WireGuardGetRunningDriverVersion(&self) -> DWORD {
        (self.WireGuardGetRunningDriverVersion)()
    }
    pub unsafe fn WireGuardDeleteDriver(&self) -> BOOL {
        (self.WireGuardDeleteDriver)()
    }
    pub unsafe fn WireGuardSetLogger(&self, arg1: WIREGUARD_LOGGER_CALLBACK) -> () {
        (self.WireGuardSetLogger)(arg1)
    }
    pub unsafe fn WireGuardSetAdapterLogging(
        &self,
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: WIREGUARD_ADAPTER_LOG_STATE,
    ) -> BOOL {
        (self.WireGuardSetAdapterLogging)(arg1, arg2)
    }
    pub unsafe fn WireGuardGetAdapterState(
        &self,
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: *mut WIREGUARD_ADAPTER_STATE,
    ) -> BOOL {
        (self.WireGuardGetAdapterState)(arg1, arg2)
    }
    pub unsafe fn WireGuardSetAdapterState(
        &self,
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: WIREGUARD_ADAPTER_STATE,
    ) -> BOOL {
        (self.WireGuardSetAdapterState)(arg1, arg2)
    }
    pub unsafe fn WireGuardGetConfiguration(
        &self,
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: *mut WIREGUARD_INTERFACE,
        arg3: *mut DWORD,
    ) -> BOOL {
        (self.WireGuardGetConfiguration)(arg1, arg2, arg3)
    }
    pub unsafe fn WireGuardSetConfiguration(
        &self,
        arg1: WIREGUARD_ADAPTER_HANDLE,
        arg2: *const WIREGUARD_INTERFACE,
        arg3: DWORD,
    ) -> BOOL {
        (self.WireGuardSetConfiguration)(arg1, arg2, arg3)
    }
}
