# wg-rust

Since this is a work in progress, I recommend looking at:

- https://crates.io/crates/wireguard-uapi for a low-level interface similar to this
- https://crates.io/crates/wireguard-control for a high-level safe interface 

This project provides rust bindings to the `embeddable-wg-library` provided by Jason Donfeld as part of his `wireguard-tools`. 

The point of the embeddable library is to be included in an application application which adds, modifies, removes, monitors, updates, or otherwise manages wireguard interfaces as part of its normal operation.

The library does *not* implement a user or kernel space wireguard implementation. For that, you want the system wireguard (`apt install wireguard`) or user-space rust implementation (`boringtun`). 

This *does* provide rust-friendly bindings to the user-side C code that interacts with the kernel via ipc calls. This allows you to *interact with* the kernel-space wireguard implementation, just like `wg-quick` or the other tools do. Since we use Jason Donfeld's code directly, it is expected to be blazing fast, secure, and error-free. 

# Building

It should build fine with `cargo build`. 

# Status

This is a work in progress. Currently unsafe wrappers are generated with `bindgen`, and the library is built using `cc` (see `build.rs`). 

The next steps are to generate safe rust interfaces and to make the layout and naming more idomatic. As such, until this reaches around a `1.0` release, I'd consider anything but the unsafe interfaces to be subject to rapid iteration.

# Copyright & Trademarks

"Wireguard" is a registered trademark of Jason Donfeld, and is not associated with, or necessarily endorsing of this project.

All code is copyright 2021 Joshua Vander Hook, AENAC Devices. 

You may use this code freely under the MIT Licsense for personal use, and we welcome any patches or contribtuions.  
