use bindgen::builder;


fn main()  
{
    // Tell Cargo that if the given file changes, to rerun this build script.
    println!("cargo:rerun-if-changed=embeddable-wg-library/wireguard.c");
    println!("cargo:rerun-if-changed=embeddable-wg-library/wireguard.h");
    // Use the `cc` crate to build a C file and statically link it.
    cc::Build::new()
        .file("embeddable-wg-library/wireguard.c")
        .compile("wg-rust.a");
    let bindings = builder()
    .header("embeddable-wg-library/wireguard.h")
    .allowlist_type("wg_allowedip") // allow only the types listed here
    .allowlist_type("wg_peer_flags") // allow only the types listed here
    .allowlist_type("wg_endpoint") // allow only the types listed here
    .allowlist_type("wg_peer") // allow only the types listed here
    .allowlist_type("wg_device_flags") // allow only the types listed here
    .allowlist_type("wg_device") // allow only the types listed here
    .allowlist_function("wg_set_device") //allow only the functions listed here
    .allowlist_function("wg_get_device") //allow only the functions listed here
    .allowlist_function("wg_add_device") //allow only the functions listed here
    .allowlist_function("wg_del_device") //allow only the functions listed here
    .allowlist_function("wg_free_device") //allow only the functions listed here
    .allowlist_function("wg_list_device_names") //allow only the functions listed here
    .allowlist_function("wg_key_to_base64") //allow only the functions listed here
    .allowlist_function("wg_key_from_base64") //allow only the functions listed here
    .allowlist_function("wg_key_is_zero") //allow only the functions listed here
    .allowlist_function("wg_generate_public_key") //allow only the functions listed here
    .allowlist_function("wg_generate_private_key") //allow only the functions listed here
    .allowlist_function("wg_generate_preshared_key") //allow only the functions listed here
    //.allowlist_recursively(false) //and really, _only_ those
    .generate().unwrap();

    // Write the generated bindings to an output file.
    bindings.write_to_file("src/lib/wg_bindings.rs").unwrap();
}
