# wg-rust

This project provides rust bindings to the `embeddable-wg-library` provided by Jason Donfeld as part of his `wireguard-tools`. 

The library does *not* implement a user or kernel space wireguard implementation. For that, you want the system wireguard (`apt install wireguard`) or user-space rust implementation (`boringtun`). 

This *does* provide rust-friendly bindings to the user-side C code that interacts with the kernel via ipc calls.

# Building

It should build fine with `cargo build`. 

# Status

This is a work in progress. Currently unsafe wrappers are generated with `bindgen`, and the library is built using `cc` (see `build.rs`). 

The next steps are to generate safe rust interfaces and to make the layout and naming more idomatic. As such, until this reaches around a `1.0` release, I'd consider anything but the unsafe interfaces to be subject to rapid iteration.

# Copyright & Trademarks

"Wireguard" is a registered trademark of Jason Donfeld, and is not associated with, or necessarily endorsing of this project.

All code is copyright 2021 Joshua Vander Hook, AENAC Devices. 

You may use this code freely under the MIT Licsense for personal use, and we welcome any patches or contribtuions.  
