#![allow(non_camel_case_types, non_upper_case_globals)]

use crate::co::{CCM, WM};

const_ordinary! { TA: u32;
	/// [`HDC::SetTextAlign`](crate::HDC::SetTextAlign) `align` (`u32`).
	///
	/// Also includes constants with `VTA` prefix.
	=>
	=>
	NOUPDATECP 0
	UPDATECP 1
	LEFT 0
	RIGHT 2
	CENTER 6
	TOP 0
	BOTTOM 8
	BASELINE 24
	RTLREADING 256
}

const_ordinary! { TB: i32;
	/// [`NMTRBTHUMBPOSCHANGING`](crate::NMTRBTHUMBPOSCHANGING) `nReason`
	/// (`i32`).
	=>
	=>
	LINEUP 0
	LINEDOWN 1
	PAGEUP 2
	PAGEDOWN 3
	THUMBPOSITION 4
	THUMBTRACK 5
	TOP 6
	BOTTOM 7
	ENDTRACK 8
}

const_wm! { TBM;
	/// Toolbar control
	/// [messages](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-toolbar-control-reference-messages)
	/// (`u32`).
	///
	/// Originally has `TB` prefix.
	=>
	=>
	ADDBITMAP WM::USER.0 + 19
	ADDBUTTONS WM::USER.0 + 68
	ADDSTRING WM::USER.0 + 77
	AUTOSIZE WM::USER.0 + 33
	BUTTONCOUNT WM::USER.0 + 24
	BUTTONSTRUCTSIZE WM::USER.0 + 30
	CHANGEBITMAP WM::USER.0 + 43
	CHECKBUTTON WM::USER.0 + 2
	COMMANDTOINDEX WM::USER.0 + 25
	CUSTOMIZE WM::USER.0 + 27
	DELETEBUTTON WM::USER.0 + 22
	ENABLEBUTTON WM::USER.0 + 1
	GETANCHORHIGHLIGHT WM::USER.0 + 74
	GETBITMAP WM::USER.0 + 44
	GETBITMAPFLAGS WM::USER.0 + 41
	GETBUTTON WM::USER.0 + 23
	GETBUTTONINFO WM::USER.0 + 63
	GETBUTTONSIZE WM::USER.0 + 58
	GETBUTTONTEXT WM::USER.0 + 75
	GETCOLORSCHEME CCM::GETCOLORSCHEME.0
	GETDISABLEDIMAGELIST WM::USER.0 + 55
	GETEXTENDEDSTYLE WM::USER.0 + 85
	GETHOTIMAGELIST WM::USER.0 + 53
	GETHOTITEM WM::USER.0 + 71
	GETIDEALSIZE WM::USER.0 + 99
	GETIMAGELIST WM::USER.0 + 49
	GETIMAGELISTCOUNT WM::USER.0 + 98
	GETINSERTMARK WM::USER.0 + 79
	GETINSERTMARKCOLOR WM::USER.0 + 89
	GETITEMDROPDOWNRECT WM::USER.0 + 103
	GETITEMRECT WM::USER.0 + 29
	GETMAXSIZE WM::USER.0 + 83
	GETMETRICS WM::USER.0 + 101
	GETOBJECT WM::USER.0 + 62
	GETPADDING WM::USER.0 + 86
	GETPRESSEDIMAGELIST WM::USER.0 + 105
	GETRECT WM::USER.0 + 51
	GETROWS WM::USER.0 + 40
	GETSTATE WM::USER.0 + 18
	GETSTRING WM::USER.0 + 91
	GETSTYLE WM::USER.0 + 57
	GETTEXTROWS WM::USER.0 + 61
	GETTOOLTIPS WM::USER.0 + 35
	GETUNICODEFORMAT CCM::GETUNICODEFORMAT.0
	HASACCELERATOR WM::USER.0 + 95
	HIDEBUTTON WM::USER.0 + 4
	HITTEST WM::USER.0 + 69
	INDETERMINATE WM::USER.0 + 5
	INSERTBUTTON WM::USER.0 + 67
	INSERTMARKHITTEST WM::USER.0 + 81
	ISBUTTONCHECKED WM::USER.0 + 10
	ISBUTTONENABLED WM::USER.0 + 9
	ISBUTTONHIDDEN WM::USER.0 + 12
	ISBUTTONHIGHLIGHTED WM::USER.0 + 14
	ISBUTTONINDETERMINATE WM::USER.0 + 13
	ISBUTTONPRESSED WM::USER.0 + 11
	LOADIMAGES WM::USER.0 + 50
	MAPACCELERATOR WM::USER.0 + 90
	MARKBUTTON WM::USER.0 + 6
	MOVEBUTTON WM::USER.0 + 82
	PRESSBUTTON WM::USER.0 + 3
	REPLACEBITMAP WM::USER.0 + 46
	SAVERESTORE WM::USER.0 + 76
	SETANCHORHIGHLIGHT WM::USER.0 + 73
	SETBITMAPSIZE WM::USER.0 + 32
	SETBOUNDINGSIZE WM::USER.0 + 93
	SETBUTTONINFO WM::USER.0 + 64
	SETBUTTONSIZE WM::USER.0 + 31
	SETBUTTONWIDTH WM::USER.0 + 59
	SETCMDID WM::USER.0 + 42
	SETCOLORSCHEME CCM::SETCOLORSCHEME.0
	SETDISABLEDIMAGELIST WM::USER.0 + 54
	SETDRAWTEXTFLAGS WM::USER.0 + 70
	SETEXTENDEDSTYLE WM::USER.0 + 84
	SETHOTIMAGELIST WM::USER.0 + 52
	SETHOTITEM WM::USER.0 + 72
	SETHOTITEM2 WM::USER.0 + 94
	SETIMAGELIST WM::USER.0 + 48
	SETINDENT WM::USER.0 + 47
	SETINSERTMARK WM::USER.0 + 80
	SETINSERTMARKCOLOR WM::USER.0 + 88
	SETLISTGAP WM::USER.0 + 96
	SETMAXTEXTROWS WM::USER.0 + 60
	SETMETRICS WM::USER.0 + 102
	SETPADDING WM::USER.0 + 87
	SETPARENT WM::USER.0 + 37
	SETPRESSEDIMAGELIST WM::USER.0 + 104
	SETREDRAWTEXTFLAGS WM::USER.0 + 70
	SETROWS WM::USER.0 + 39
	SETSTATE WM::USER.0 + 17
	SETSTYLE WM::USER.0 + 56
	SETTOOLTIPS WM::USER.0 + 36
	SETUNICODEFORMAT CCM::SETUNICODEFORMAT.0
	SETWINDOWTHEME CCM::SETWINDOWTHEME.0
}

const_nm! { TBN;
	/// Toolbar control `WM_NOTIFY`
	/// [notifications](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-toolbar-control-reference-notifications)
	/// (`i32`).
	=>
	FIRST -700
	=>
	BEGINADJUST Self::FIRST.0 - 3
	BEGINDRAG Self::FIRST.0 - 1
	CUSTHELP Self::FIRST.0 - 9
	DELETINGBUTTON Self::FIRST.0 - 15
	DRAGOUT Self::FIRST.0 - 14
	DRAGOVER Self::FIRST.0 - 27
	DROPDOWN Self::FIRST.0 - 10
	DUPACCELERATOR Self::FIRST.0 - 25
	ENDADJUST Self::FIRST.0 - 4
	ENDDRAG Self::FIRST.0 - 2
	GETBUTTONINFO Self::FIRST.0 - 20
	GETDISPINFO Self::FIRST.0 - 17
	GETINFOTIP Self::FIRST.0 - 19
	GETOBJECT Self::FIRST.0 - 12
	HOTITEMCHANGE Self::FIRST.0 - 13
	INITCUSTOMIZE Self::FIRST.0 - 23
	MAPACCELERATOR Self::FIRST.0 - 28
	QUERYDELETE Self::FIRST.0 - 7
	QUERYINSERT Self::FIRST.0 - 6
	RESET Self::FIRST.0 - 5
	RESTORE Self::FIRST.0 - 21
	SAVE Self::FIRST.0 - 22
	TOOLBARCHANGE Self::FIRST.0 - 8
	WRAPACCELERATOR Self::FIRST.0 - 26
	WRAPHOTITEM Self::FIRST.0 - 24
}

const_ws! { TBS: u32;
	/// Trackbar control
	/// [styles](https://docs.microsoft.com/en-us/windows/win32/controls/trackbar-control-styles)
	/// (`u32`).
	=>
	=>
	AUTOTICKS 0x0001
	VERT 0x0002
	HORZ 0x0000
	TOP 0x0004
	BOTTOM 0x0000
	LEFT 0x0004
	RIGHT 0x0000
	BOTH 0x0008
	NOTICKS 0x0010
	ENABLESELRANGE 0x0020
	FIXEDLENGTH 0x0040
	NOTHUMB 0x0080
	TOOLTIPS 0x0100
	REVERSED 0x0200
	DOWNISLEFT 0x0400
	NOTIFYBEFOREMOVE 0x0800
	TRANSPARENTBKGND 0x1000
}

const_ordinary! { TBSTATE: u8;
	/// Toolbar button
	/// [states](https://docs.microsoft.com/en-us/windows/win32/controls/toolbar-button-states)
	/// (`u8`).
	=>
	=>
	/// None of the actual values (zero).
	NoValue 0
	CHECKED 0x01
	PRESSED 0x02
	ENABLED 0x04
	HIDDEN 0x08
	INDETERMINATE 0x10
	WRAP 0x20
	ELLIPSES 0x40
	MARKED 0x80
}

const_ordinary! { TCIS: u32;
	/// Tab control item
	/// [states](https://docs.microsoft.com/en-us/windows/win32/controls/tab-control-item-states)
	/// (`u32`).
	=>
	=>
	/// None of the actual values (zero).
	NoValue 0
	BUTTONPRESSED 0x0001
	HIGHLIGHTED 0x0002
}

const_wm! { TCM;
	/// Tab control
	/// [messages](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-tab-control-reference-messages)
	/// (`u32`).
	=>
	FIRST 0x1300
	=>
	GETIMAGELIST Self::FIRST.0 + 2
	SETIMAGELIST Self::FIRST.0 + 3
	GETITEMCOUNT Self::FIRST.0 + 4
	GETITEM Self::FIRST.0 + 60
	SETITEM Self::FIRST.0 + 61
	INSERTITEM Self::FIRST.0 + 62
	DELETEITEM Self::FIRST.0 + 8
	DELETEALLITEMS Self::FIRST.0 + 9
	GETITEMRECT Self::FIRST.0 + 10
	GETCURSEL Self::FIRST.0 + 11
	SETCURSEL Self::FIRST.0 + 12
	HITTEST Self::FIRST.0 + 13
	SETITEMEXTRA Self::FIRST.0 + 14
	ADJUSTRECT Self::FIRST.0 + 40
	SETITEMSIZE Self::FIRST.0 + 41
	REMOVEIMAGE Self::FIRST.0 + 42
	SETPADDING Self::FIRST.0 + 43
	GETROWCOUNT Self::FIRST.0 + 44
	GETTOOLTIPS Self::FIRST.0 + 45
	SETTOOLTIPS Self::FIRST.0 + 46
	GETCURFOCUS Self::FIRST.0 + 47
	SETCURFOCUS Self::FIRST.0 + 48
	SETMINTABWIDTH Self::FIRST.0 + 49
	DESELECTALL Self::FIRST.0 + 50
	HIGHLIGHTITEM Self::FIRST.0 + 51
	SETEXTENDEDSTYLE Self::FIRST.0 + 52
	GETEXTENDEDSTYLE Self::FIRST.0 + 53
	SETUNICODEFORMAT CCM::SETUNICODEFORMAT.0
	GETUNICODEFORMAT CCM::GETUNICODEFORMAT.0
}

const_nm! { TCN;
	/// Tab control `WM_NOTIFY`
	/// [notifications](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-tab-control-reference-notifications)
	/// (`i32`).
	=>
	FIRST -550
	=>
	FOCUSCHANGE Self::FIRST.0 - 4
	GETOBJECT Self::FIRST.0 - 3
	KEYDOWN Self::FIRST.0 - 0
	SELCHANGE Self::FIRST.0 - 1
	SELCHANGING Self::FIRST.0 - 2
}

const_ws! { TCS: u32;
	/// Tab control
	/// [styles](https://docs.microsoft.com/en-us/windows/win32/controls/tab-control-styles)
	/// (`u32`).
	=>
	=>
	SCROLLOPPOSITE 0x0001
	BOTTOM 0x0002
	RIGHT 0x0002
	MULTISELECT 0x0004
	FLATBUTTONS 0x0008
	FORCEICONLEFT 0x0010
	FORCELABELLEFT 0x0020
	HOTTRACK 0x0040
	VERTICAL 0x0080
	TABS 0x0000
	BUTTONS 0x0100
	SINGLELINE 0x0000
	MULTILINE 0x0200
	RIGHTJUSTIFY 0x0000
	FIXEDWIDTH 0x0400
	RAGGEDRIGHT 0x0800
	FOCUSONBUTTONDOWN 0x1000
	OWNERDRAWFIXED 0x2000
	TOOLTIPS 0x4000
	FOCUSNEVER 0x8000
}

const_wsex! { TCS_EX;
	/// Extended tab control
	/// [styles](https://docs.microsoft.com/en-us/windows/win32/controls/tab-control-extended-styles)
	/// (`u32`).
	=>
	=>
	FLATSEPARATORS 0x0000_0001
	REGISTERDROP 0x0000_0002
}

const_ordinary! { TD_ICON: u16;
	/// [`HWND::TaskDialog`](crate::HWND::TaskDialog) `pszIcon` and
	/// [`TASKDIALOGCONFIG`](crate::TASKDIALOGCONFIG) `pszMainIcon` (`u16`).
	/// Originally has `TD` prefix and `ICON` suffix.
	=>
	=>
	WARNING 0xffff
	ERROR 0xfffe
	INFORMATION 0xfffd
	SHIELD 0xfffc
}

const_ordinary! { TDCBF: i32;
	/// [`HWND::TaskDialog`](crate::HWND::TaskDialog) and
	/// [`TASKDIALOGCONFIG`](crate::TASKDIALOGCONFIG) `dwCommonButtons` (`i32`).
	/// Originally has `TDCBF` prefix and `BUTTON` suffix.
	=>
	=>
	OK 0x0001
	YES 0x0002
	NO 0x0004
	CANCEL 0x0008
	RETRY 0x0010
	CLOSE 0x0020
}

const_ordinary! { TDF: i32;
	/// [`TASKDIALOGCONFIG`](crate::TASKDIALOGCONFIG) `dwFlags` (`i32`).
	=>
	=>
	ENABLE_HYPERLINKS 0x0001
	USE_HICON_MAIN 0x0002
	USE_HICON_FOOTER 0x0004
	ALLOW_DIALOG_CANCELLATION 0x0008
	USE_COMMAND_LINKS 0x0010
	USE_COMMAND_LINKS_NO_ICON 0x0020
	EXPAND_FOOTER_AREA 0x0040
	EXPANDED_BY_DEFAULT 0x0080
	VERIFICATION_FLAG_CHECKED 0x0100
	SHOW_PROGRESS_BAR 0x0200
	SHOW_MARQUEE_PROGRESS_BAR 0x0400
	CALLBACK_TIMER 0x0800
	POSITION_RELATIVE_TO_WINDOW 0x1000
	RTL_LAYOUT 0x2000
	NO_DEFAULT_RADIO_BUTTON 0x4000
	CAN_BE_MINIMIZED 0x8000
	NO_SET_FOREGROUND 0x0001_0000
	SIZE_TO_CONTENT 0x0100_0000
}

const_ordinary! { TH32CS: u32;
	/// [`HPROCESSLIST::CreateToolhelp32Snapshot`](crate::HPROCESSLIST) `flags`
	/// (`u32`).
	=>
	=>
	SNAPHEAPLIST 0x0000_0001
	SNAPPROCESS 0x0000_0002
	SNAPTHREAD 0x0000_0004
	SNAPMODULE 0x0000_0008
	SNAPMODULE32 0x0000_0010
	SNAPALL Self::SNAPHEAPLIST.0 | Self::SNAPPROCESS.0 | Self::SNAPTHREAD.0 | Self::SNAPMODULE.0
	INHERIT 0x8000_0000
}

const_ordinary! { THREAD_CREATE: u32;
	/// [`HTHREAD::CreateThread`](crate::HTHREAD::CreateThread) `flags` (`u32`).
	/// Originally has no prefix.
	=>
	=>
	/// Originally just a zero.
	RUN_IMMEDIATELY 0
	CREATE_SUSPENDED 0x0000_0004
	STACK_SIZE_PARAM_IS_A_RESERVATION 0x0001_0000
}

const_ordinary! { TME: u32;
	/// [`TrackMouseEvent`](crate::TrackMouseEvent) `dwFlags` (`u32`).
	=>
	=>
	CANCEL 0x8000_0000
	HOVER 0x0000_0001
	LEAVE 0x0000_0002
	NONCLIENT 0x0000_0010
	QUERY 0x4000_0000
}

const_ordinary! { TMT: i32;
	/// Theme property
	/// [identifiers](https://docs.microsoft.com/en-us/windows/win32/controls/property-typedefs)
	/// (`i32`).
	=>
	=>
	DIBDATA 2
	GLYPHDIBDATA 8
	ENUM 200
	STRING 201
	INT 202
	BOOL 203
	COLOR 204
	MARGINS 205
	FILENAME 206
	SIZE 207
	POSITION 208
	RECT 209
	FONT 210
	INTLIST 211
	HBITMAP 212
	DISKSTREAM 213
	STREAM 214
	BITMAPREF 215
	FLOAT 216
	FLOATLIST 217
	COLORSCHEMES 401
	SIZES 402
	CHARSET 403
	NAME 600
	DISPLAYNAME 601
	TOOLTIP 602
	COMPANY 603
	AUTHOR 604
	COPYRIGHT 605
	URL 606
	VERSION 607
	DESCRIPTION 608
	FIRST_RCSTRING_NAME Self::DISPLAYNAME.0
	LAST_RCSTRING_NAME Self::DESCRIPTION.0
	CAPTIONFONT 801
	SMALLCAPTIONFONT 802
	MENUFONT 803
	STATUSFONT 804
	MSGBOXFONT 805
	ICONTITLEFONT 806
	HEADING1FONT 807
	HEADING2FONT 808
	BODYFONT 809
	FIRSTFONT Self::CAPTIONFONT.0
	LASTFONT Self::BODYFONT.0
	FLATMENUS 1001
	FIRSTBOOL Self::FLATMENUS.0
	LASTBOOL Self::FLATMENUS.0
	SIZINGBORDERWIDTH 1201
	SCROLLBARWIDTH 1202
	SCROLLBARHEIGHT 1203
	CAPTIONBARWIDTH 1204
	CAPTIONBARHEIGHT 1205
	SMCAPTIONBARWIDTH 1206
	SMCAPTIONBARHEIGHT 1207
	MENUBARWIDTH 1208
	MENUBARHEIGHT 1209
	PADDEDBORDERWIDTH 1210
	FIRSTSIZE Self::SIZINGBORDERWIDTH.0
	LASTSIZE Self::PADDEDBORDERWIDTH.0
	MINCOLORDEPTH 1301
	FIRSTINT Self::MINCOLORDEPTH.0
	LASTINT Self::MINCOLORDEPTH.0
	CSSNAME 1401
	XMLNAME 1402
	LASTUPDATED 1403
	ALIAS 1404
	FIRSTSTRING Self::CSSNAME.0
	LASTSTRING Self::ALIAS.0
	SCROLLBAR 1601
	BACKGROUND 1602
	ACTIVECAPTION 1603
	INACTIVECAPTION 1604
	MENU 1605
	WINDOW 1606
	WINDOWFRAME 1607
	MENUTEXT 1608
	WINDOWTEXT 1609
	CAPTIONTEXT 1610
	ACTIVEBORDER 1611
	INACTIVEBORDER 1612
	APPWORKSPACE 1613
	HIGHLIGHT 1614
	HIGHLIGHTTEXT 1615
	BTNFACE 1616
	BTNSHADOW 1617
	GRAYTEXT 1618
	BTNTEXT 1619
	INACTIVECAPTIONTEXT 1620
	BTNHIGHLIGHT 1621
	DKSHADOW3D 1622
	LIGHT3D 1623
	INFOTEXT 1624
	INFOBK 1625
	BUTTONALTERNATEFACE 1626
	HOTTRACKING 1627
	GRADIENTACTIVECAPTION 1628
	GRADIENTINACTIVECAPTION 1629
	MENUHILIGHT 1630
	MENUBAR 1631
	FIRSTCOLOR Self::SCROLLBAR.0
	LASTCOLOR Self::MENUBAR.0
	FROMHUE1 1801
	FROMHUE2 1802
	FROMHUE3 1803
	FROMHUE4 1804
	FROMHUE5 1805
	TOHUE1 1806
	TOHUE2 1807
	TOHUE3 1808
	TOHUE4 1809
	TOHUE5 1810
	FROMCOLOR1 2001
	FROMCOLOR2 2002
	FROMCOLOR3 2003
	FROMCOLOR4 2004
	FROMCOLOR5 2005
	TOCOLOR1 2006
	TOCOLOR2 2007
	TOCOLOR3 2008
	TOCOLOR4 2009
	TOCOLOR5 2010
	TRANSPARENT 2201
	AUTOSIZE 2202
	BORDERONLY 2203
	COMPOSITED 2204
	BGFILL 2205
	GLYPHTRANSPARENT 2206
	GLYPHONLY 2207
	ALWAYSSHOWSIZINGBAR 2208
	MIRRORIMAGE 2209
	UNIFORMSIZING 2210
	INTEGRALSIZING 2211
	SOURCEGROW 2212
	SOURCESHRINK 2213
	DRAWBORDERS 2214
	NOETCHEDEFFECT 2215
	TEXTAPPLYOVERLAY 2216
	TEXTGLOW 2217
	TEXTITALIC 2218
	COMPOSITEDOPAQUE 2219
	LOCALIZEDMIRRORIMAGE 2220
	IMAGECOUNT 2401
	ALPHALEVEL 2402
	BORDERSIZE 2403
	ROUNDCORNERWIDTH 2404
	ROUNDCORNERHEIGHT 2405
	GRADIENTRATIO1 2406
	GRADIENTRATIO2 2407
	GRADIENTRATIO3 2408
	GRADIENTRATIO4 2409
	GRADIENTRATIO5 2410
	PROGRESSCHUNKSIZE 2411
	PROGRESSSPACESIZE 2412
	SATURATION 2413
	TEXTBORDERSIZE 2414
	ALPHATHRESHOLD 2415
	WIDTH 2416
	HEIGHT 2417
	GLYPHINDEX 2418
	TRUESIZESTRETCHMARK 2419
	MINDPI1 2420
	MINDPI2 2421
	MINDPI3 2422
	MINDPI4 2423
	MINDPI5 2424
	TEXTGLOWSIZE 2425
	FRAMESPERSECOND 2426
	PIXELSPERFRAME 2427
	ANIMATIONDELAY 2428
	GLOWINTENSITY 2429
	OPACITY 2430
	COLORIZATIONCOLOR 2431
	COLORIZATIONOPACITY 2432
	MINDPI6 2433
	MINDPI7 2434
	GLYPHFONT 2601
	IMAGEFILE 3001
	IMAGEFILE1 3002
	IMAGEFILE2 3003
	IMAGEFILE3 3004
	IMAGEFILE4 3005
	IMAGEFILE5 3006
	GLYPHIMAGEFILE 3008
	IMAGEFILE6 3009
	IMAGEFILE7 3010
	TEXT 3201
	CLASSICVALUE 3202
	OFFSET 3401
	TEXTSHADOWOFFSET 3402
	MINSIZE 3403
	MINSIZE1 3404
	MINSIZE2 3405
	MINSIZE3 3406
	MINSIZE4 3407
	MINSIZE5 3408
	NORMALSIZE 3409
	MINSIZE6 3410
	MINSIZE7 3411
	SIZINGMARGINS 3601
	CONTENTMARGINS 3602
	CAPTIONMARGINS 3603
	BORDERCOLOR 3801
	FILLCOLOR 3802
	TEXTCOLOR 3803
	EDGELIGHTCOLOR 3804
	EDGEHIGHLIGHTCOLOR 3805
	EDGESHADOWCOLOR 3806
	EDGEDKSHADOWCOLOR 3807
	EDGEFILLCOLOR 3808
	TRANSPARENTCOLOR 3809
	GRADIENTCOLOR1 3810
	GRADIENTCOLOR2 3811
	GRADIENTCOLOR3 3812
	GRADIENTCOLOR4 3813
	GRADIENTCOLOR5 3814
	SHADOWCOLOR 3815
	GLOWCOLOR 3816
	TEXTBORDERCOLOR 3817
	TEXTSHADOWCOLOR 3818
	GLYPHTEXTCOLOR 3819
	GLYPHTRANSPARENTCOLOR 3820
	FILLCOLORHINT 3821
	BORDERCOLORHINT 3822
	ACCENTCOLORHINT 3823
	TEXTCOLORHINT 3824
	HEADING1TEXTCOLOR 3825
	HEADING2TEXTCOLOR 3826
	BODYTEXTCOLOR 3827
	BGTYPE 4001
	BORDERTYPE 4002
	FILLTYPE 4003
	SIZINGTYPE 4004
	HALIGN 4005
	CONTENTALIGNMENT 4006
	VALIGN 4007
	OFFSETTYPE 4008
	ICONEFFECT 4009
	TEXTSHADOWTYPE 4010
	IMAGELAYOUT 4011
	GLYPHTYPE 4012
	IMAGESELECTTYPE 4013
	GLYPHFONTSIZINGTYPE 4014
	TRUESIZESCALINGTYPE 4015
	USERPICTURE 5001
	DEFAULTPANESIZE 5002
	BLENDCOLOR 5003
	CUSTOMSPLITRECT 5004
	ANIMATIONBUTTONRECT 5005
	ANIMATIONDURATION 5006
	TRANSITIONDURATIONS 6000
	SCALEDBACKGROUND 7001
	ATLASIMAGE 8000
	ATLASINPUTIMAGE 8001
	ATLASRECT 8002
}

const_ordinary! { TPM: u32;
	/// [`TrackPopupMenu`](crate::HMENU::TrackPopupMenu) `flags` (`u32`).
	=>
	=>
	LEFTBUTTON 0x0000
	RIGHTBUTTON 0x0002
	LEFTALIGN 0x0000
	CENTERALIGN 0x0004
	RIGHTALIGN 0x0008
	TOPALIGN 0x0000
	VCENTERALIGN 0x0010
	BOTTOMALIGN 0x0020
	HORIZONTAL 0x0000
	VERTICAL 0x0040
	NONOTIFY 0x0080
	RETURNCMD 0x0100
	RECURSE 0x0001
	HORPOSANIMATION 0x0400
	HORNEGANIMATION 0x0800
	VERPOSANIMATION 0x1000
	VERNEGANIMATION 0x2000
	NOANIMATION 0x4000
	LAYOUTRTL 0x8000
	WORKAREA 0x10000
}

const_wm! { TRBM;
	/// Trackbar control
	/// [messages](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-trackbar-control-reference-messages)
	/// (`u32`).
	///
	/// Originally has `TBM` prefix.
	=>
	=>
	GETPOS WM::USER.0
	GETRANGEMIN WM::USER.0 + 1
	GETRANGEMAX WM::USER.0 + 2
	GETTIC WM::USER.0 + 3
	SETTIC WM::USER.0 + 4
	SETPOS WM::USER.0 + 5
	SETRANGE WM::USER.0 + 6
	SETRANGEMIN WM::USER.0 + 7
	SETRANGEMAX WM::USER.0 + 8
	CLEARTICS WM::USER.0 + 9
	SETSEL WM::USER.0 + 10
	SETSELSTART WM::USER.0 + 11
	SETSELEND WM::USER.0 + 12
	GETPTICS WM::USER.0 + 14
	GETTICPOS WM::USER.0 + 15
	GETNUMTICS WM::USER.0 + 16
	GETSELSTART WM::USER.0 + 17
	GETSELEND WM::USER.0 + 18
	CLEARSEL WM::USER.0 + 19
	SETTICFREQ WM::USER.0 + 20
	SETPAGESIZE WM::USER.0 + 21
	GETPAGESIZE WM::USER.0 + 22
	SETLINESIZE WM::USER.0 + 23
	GETLINESIZE WM::USER.0 + 24
	GETTHUMBRECT WM::USER.0 + 25
	GETCHANNELRECT WM::USER.0 + 26
	SETTHUMBLENGTH WM::USER.0 + 27
	GETTHUMBLENGTH WM::USER.0 + 28
	SETTOOLTIPS WM::USER.0 + 29
	GETTOOLTIPS WM::USER.0 + 30
	SETTIPSIDE WM::USER.0 + 31
	SETBUDDY WM::USER.0 + 32
	GETBUDDY WM::USER.0 + 33
	SETPOSNOTIFY WM::USER.0 + 34
	SETUNICODEFORMAT CCM::SETUNICODEFORMAT.0
	GETUNICODEFORMAT CCM::GETUNICODEFORMAT.0
}

const_nm! { TRBN;
	/// Trackbar control `WM_NOTIFY`
	/// [notifications](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-trackbar-control-reference-notifications)
	/// (`i32`).
	=>
	FIRST -1501
	=>
	THUMBPOSCHANGING Self::FIRST.0 - 1
}

const_ordinary! { TTI: i32;
	/// [`EDITBALLOONTIP`](crate::EDITBALLOONTIP) ttiIcon (`i32`).
	=>
	=>
	ERROR 3
	INFO 1
	NONE 0
	WARNING 2
	INFO_LARGE 4
	WARNING_LARGE 5
	ERROR_LARGE 6
}

const_ordinary! { TVE: u32;
	/// [`tvm::Expand`](crate::msg::tvm::Expand) `action` (`u32`).
	=>
	=>
	COLLAPSE 0x0001
	EXPAND 0x0002
	TOGGLE 0x0003
	EXPANDPARTIAL 0x4000
	COLLAPSERESET 0x8000
}

const_ordinary! { TVGN: u32;
	/// [`tvm::GetNextItem`](crate::msg::tvm::GetNextItem) `which` (`u32`).
	=>
	=>
	ROOT 0x0000
	NEXT 0x0001
	PREVIOUS 0x0002
	PARENT 0x0003
	CHILD 0x0004
	FIRSTVISIBLE 0x0005
	NEXTVISIBLE 0x0006
	PREVIOUSVISIBLE 0x0007
	DROPHILITE 0x0008
	CARET 0x0009
	LASTVISIBLE 0x000a
	NEXTSELECTED 0x000b
	/// Originally has no `TVGN` prefix.
	TVSI_NOSINGLEEXPAND 0x8000
}

const_ordinary! { TVI: isize;
	/// [`TVINSERTSTRUCT`](crate::TVINSERTSTRUCT) `hInsertAfter` (`isize`).
	=>
	=>
	ROOT -0x10000
	FIRST -0x0ffff
	LAST -0x0fffe
	SORT -0x0fffd
}

const_ordinary! { TVIF: u32;
	/// [`TVITEM`](crate::TVITEM) `mask` (`u32`).
	=>
	=>
	TEXT 0x0001
	IMAGE 0x0002
	PARAM 0x0004
	STATE 0x0008
	HANDLE 0x0010
	SELECTEDIMAGE 0x0020
	CHILDREN 0x0040
	INTEGRAL 0x0080
	STATEEX 0x0100
	EXPANDEDIMAGE 0x0200
}

const_ordinary! { TVIS: u32;
	/// Tree view item
	/// [states](https://docs.microsoft.com/en-us/windows/win32/controls/tree-view-control-item-states)
	/// (`u32`)
	=>
	=>
	/// None of the actual values (zero).
	NoValue 0
	SELECTED 0x0002
	CUT 0x0004
	DROPHILITED 0x0008
	BOLD 0x0010
	EXPANDED 0x0020
	EXPANDEDONCE 0x0040
	EXPANDPARTIAL 0x0080
	OVERLAYMASK 0x0f00
	STATEIMAGEMASK 0xf000
	USERMASK 0xf000
}

const_ordinary! { TVIS_EX: u32;
	/// [`TVITEMEX`](crate::TVITEMEX) `uStateEx` (`u32`).
	=>
	=>
	DISABLED 0x0002
	FLAT 0x0001
	/// This value is not declared in any header, it may not be accurate.
	HWND 0x0000
}

const_wm! { TVM;
	/// Tree view control
	/// [messages](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-tree-view-control-reference-messages)
	/// (`u32`).
	=>
	FIRST 0x1100
	=>
	INSERTITEM Self::FIRST.0 + 50
	DELETEITEM Self::FIRST.0 + 1
	EXPAND Self::FIRST.0 + 2
	GETITEMRECT Self::FIRST.0 + 4
	GETCOUNT Self::FIRST.0 + 5
	GETINDENT Self::FIRST.0 + 6
	SETINDENT Self::FIRST.0 + 7
	GETIMAGELIST Self::FIRST.0 + 8
	SETIMAGELIST Self::FIRST.0 + 9
	GETNEXTITEM Self::FIRST.0 + 10
	SELECTITEM Self::FIRST.0 + 11
	GETITEM Self::FIRST.0 + 62
	SETITEM Self::FIRST.0 + 63
	EDITLABEL Self::FIRST.0 + 65
	GETEDITCONTROL Self::FIRST.0 + 15
	GETVISIBLECOUNT Self::FIRST.0 + 16
	HITTEST Self::FIRST.0 + 17
	CREATEDRAGIMAGE Self::FIRST.0 + 18
	SORTCHILDREN Self::FIRST.0 + 19
	ENSUREVISIBLE Self::FIRST.0 + 20
	SORTCHILDRENCB Self::FIRST.0 + 21
	ENDEDITLABELNOW Self::FIRST.0 + 22
	GETISEARCHSTRING Self::FIRST.0 + 64
	SETTOOLTIPS Self::FIRST.0 + 24
	GETTOOLTIPS Self::FIRST.0 + 25
	SETINSERTMARK Self::FIRST.0 + 26
	SETUNICODEFORMAT CCM::SETUNICODEFORMAT.0
	GETUNICODEFORMAT CCM::GETUNICODEFORMAT.0
	SETITEMHEIGHT Self::FIRST.0 + 27
	GETITEMHEIGHT Self::FIRST.0 + 28
	SETBKCOLOR Self::FIRST.0 + 29
	SETTEXTCOLOR Self::FIRST.0 + 30
	GETBKCOLOR Self::FIRST.0 + 31
	GETTEXTCOLOR Self::FIRST.0 + 32
	SETSCROLLTIME Self::FIRST.0 + 33
	GETSCROLLTIME Self::FIRST.0 + 34
	SETINSERTMARKCOLOR Self::FIRST.0 + 37
	GETINSERTMARKCOLOR Self::FIRST.0 + 38
	SETBORDER Self::FIRST.0 + 35
	GETITEMSTATE Self::FIRST.0 + 39
	SETLINECOLOR Self::FIRST.0 + 40
	GETLINECOLOR Self::FIRST.0 + 41
	MAPACCIDTOHTREEITEM Self::FIRST.0 + 42
	MAPHTREEITEMTOACCID Self::FIRST.0 + 43
	SETEXTENDEDSTYLE Self::FIRST.0 + 44
	GETEXTENDEDSTYLE Self::FIRST.0 + 45
	SETAUTOSCROLLINFO Self::FIRST.0 + 59
	SETHOT Self::FIRST.0 + 58
	GETSELECTEDCOUNT Self::FIRST.0 + 70
	SHOWINFOTIP Self::FIRST.0 + 71
	GETITEMPARTRECT Self::FIRST.0 + 72
}

const_nm! { TVN;
	/// Tree view control `WM_NOTIFY`
	/// [notifications](https://docs.microsoft.com/en-us/windows/win32/controls/bumper-tree-view-control-reference-notifications)
	/// (`i32`).
	=>
	FIRST -400
	=>
	SELCHANGING Self::FIRST.0 - 50
	SELCHANGED Self::FIRST.0 - 51
	GETDISPINFO Self::FIRST.0 - 52
	SETDISPINFO Self::FIRST.0 - 53
	ITEMEXPANDING Self::FIRST.0 - 54
	ITEMEXPANDED Self::FIRST.0 - 55
	BEGINDRAG Self::FIRST.0 - 56
	BEGINRDRAG Self::FIRST.0 - 57
	DELETEITEM Self::FIRST.0 - 58
	BEGINLABELEDIT Self::FIRST.0 - 59
	ENDLABELEDIT Self::FIRST.0 - 60
	KEYDOWN Self::FIRST.0 - 12
	GETINFOTIP Self::FIRST.0 - 14
	SINGLEEXPAND Self::FIRST.0 - 15
	ITEMCHANGING Self::FIRST.0 - 17
	ITEMCHANGED Self::FIRST.0 - 19
	ASYNCDRAW Self::FIRST.0 - 20
}

const_ws! { TVS: u32;
	/// Tree view control
	/// [styles](https://docs.microsoft.com/en-us/windows/win32/controls/tree-view-control-window-styles)
	/// (`u32`).
	=>
	=>
	HASBUTTONS 0x0001
	HASLINES 0x0002
	LINESATROOT 0x0004
	EDITLABELS 0x0008
	DISABLEDRAGDROP 0x0010
	SHOWSELALWAYS 0x0020
	RTLREADING 0x0040
	NOTOOLTIPS 0x0080
	CHECKBOXES 0x0100
	TRACKSELECT 0x0200
	SINGLEEXPAND 0x0400
	INFOTIP 0x0800
	FULLROWSELECT 0x1000
	NOSCROLL 0x2000
	NONEVENHEIGHT 0x4000
	NOHSCROLL 0x8000
}

const_wsex! { TVS_EX;
	/// Extended tree view control
	/// [styles](https://docs.microsoft.com/en-us/windows/win32/controls/tree-view-control-window-extended-styles)
	/// (`u32`).
	=>
	=>
	/// None of the actual values (zero).
	NoValue 0
	NOSINGLECOLLAPSE 0x0001
	MULTISELECT 0x0002
	DOUBLEBUFFER 0x0004
	NOINDENTSTATE 0x0008
	RICHTOOLTIP 0x0010
	AUTOHSCROLL 0x0020
	FADEINOUTEXPANDOS 0x0040
	PARTIALCHECKBOXES 0x0080
	EXCLUSIONCHECKBOXES 0x0100
	DIMMEDCHECKBOXES 0x0200
	DRAWIMAGEASYNC 0x0400
}

const_ordinary! { TVSIL: u8;
	/// [`tvm::GetImageList`](crate::msg::tvm::GetImageList) and
	/// [`tvm::SetImageList`](crate::msg::tvm::SetImageList) `kind`.
	=>
	=>
	NORMAL 0
	STATE 2
}
